/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.Status;
import net.sf.ehcache.TransactionController;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterScheme;
import net.sf.ehcache.cluster.ClusterSchemeNotAvailableException;
import net.sf.ehcache.cluster.NoopCacheCluster;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.TerracottaClientConfiguration;
import net.sf.ehcache.config.generator.ConfigurationUtil;
import net.sf.ehcache.constructs.nonstop.CacheManagerExecutorServiceFactory;
import net.sf.ehcache.distribution.CacheManagerPeerListener;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerRegistry;
import net.sf.ehcache.management.provider.MBeanRegistrationProvider;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderException;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderFactory;
import net.sf.ehcache.management.provider.MBeanRegistrationProviderFactoryImpl;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.terracotta.ClusteredInstanceFactory;
import net.sf.ehcache.terracotta.TerracottaClient;
import net.sf.ehcache.terracotta.TerracottaClientRejoinListener;
import net.sf.ehcache.transaction.ReadCommittedSoftLockFactoryImpl;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.TransactionIDFactoryImpl;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.processor.XARequestProcessor;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.PropertyUtil;
import net.sf.ehcache.util.UpdateChecker;
import net.sf.ehcache.writer.writebehind.WriteBehind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheManager {
    public static final String DEFAULT_NAME = "__DEFAULT__";
    public static final List<CacheManager> ALL_CACHE_MANAGERS = new CopyOnWriteArrayList<CacheManager>();
    public static final String ENABLE_SHUTDOWN_HOOK_PROPERTY = "net.sf.ehcache.enableShutdownHook";
    private static final Logger LOG = LoggerFactory.getLogger(CacheManager.class);
    private static final long EVERY_WEEK = 604800000L;
    private static final long DELAY_UPDATE_CHECK = 1000L;
    private static volatile CacheManager singleton;
    private static final MBeanRegistrationProviderFactory MBEAN_REGISTRATION_PROVIDER_FACTORY;
    private static final String NO_DEFAULT_CACHE_ERROR_MSG = "Caches cannot be added by name when default cache config is not specified in the config. Please add a default cache config in the configuration.";
    protected volatile String name;
    protected volatile Status status;
    protected final Map<String, CacheManagerPeerProvider> cacheManagerPeerProviders = new ConcurrentHashMap<String, CacheManagerPeerProvider>();
    protected final Map<String, CacheManagerPeerListener> cacheManagerPeerListeners = new ConcurrentHashMap<String, CacheManagerPeerListener>();
    protected final CacheManagerEventListenerRegistry cacheManagerEventListenerRegistry = new CacheManagerEventListenerRegistry();
    protected Thread shutdownHook;
    private final ConcurrentMap<String, Ehcache> ehcaches = new ConcurrentHashMap<String, Ehcache>();
    private Ehcache defaultCache;
    private String diskStorePath;
    private MBeanRegistrationProvider mbeanRegistrationProvider;
    private FailSafeTimer cacheManagerTimer;
    private volatile TerracottaClient terracottaClient;
    private TerracottaClientConfiguration terracottaClientConfiguration;
    private Configuration configuration;
    private volatile boolean allowsDynamicCacheConfig = true;
    private volatile TransactionManagerLookup transactionManagerLookup;
    private volatile TransactionController transactionController;
    private final ConcurrentMap<String, SoftLockFactory> softLockFactories = new ConcurrentHashMap<String, SoftLockFactory>();

    public CacheManager(Configuration configuration) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(configuration, null, null, null);
    }

    public CacheManager(String configurationFileName) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, configurationFileName, null, null);
    }

    public CacheManager(URL configurationURL) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, configurationURL, null);
    }

    public CacheManager(InputStream configurationInputStream) throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, configurationInputStream);
    }

    public CacheManager() throws CacheException {
        this.status = Status.STATUS_UNINITIALISED;
        this.init(null, null, null, null);
    }

    protected void init(Configuration initialConfiguration, String configurationFileName, URL configurationURL, InputStream configurationInputStream) {
        Configuration localConfiguration = initialConfiguration;
        this.configuration = initialConfiguration == null ? (localConfiguration = this.parseConfiguration(configurationFileName, configurationURL, configurationInputStream)) : initialConfiguration;
        if (this.configuration.getTerracottaConfiguration() != null) {
            this.configuration.getTerracottaConfiguration().freezeConfig();
        }
        this.validateConfiguration();
        if (localConfiguration.getName() != null) {
            this.name = localConfiguration.getName();
        }
        this.allowsDynamicCacheConfig = localConfiguration.getDynamicConfig();
        this.terracottaClientConfiguration = localConfiguration.getTerracottaConfiguration();
        this.terracottaClient = new TerracottaClient(this, new TerracottaClientRejoinListener(){

            public void clusterRejoinStarted() {
                CacheManager.this.clusterRejoinStarted();
            }

            public void clusterRejoinComplete() {
                CacheManager.this.clusterRejoinComplete();
            }
        }, localConfiguration.getTerracottaConfiguration());
        Map<String, CacheConfiguration> cacheConfigs = localConfiguration.getCacheConfigurations();
        if (localConfiguration.getDefaultCacheConfiguration() != null && localConfiguration.getDefaultCacheConfiguration().isTerracottaClustered()) {
            this.terracottaClient.createClusteredInstanceFactory(cacheConfigs);
        } else {
            for (CacheConfiguration config : cacheConfigs.values()) {
                if (!config.isTerracottaClustered()) continue;
                this.terracottaClient.createClusteredInstanceFactory(cacheConfigs);
                break;
            }
        }
        if (this.terracottaClient.getClusteredInstanceFactory() != null && this.name == null) {
            this.name = DEFAULT_NAME;
        }
        TransactionIDFactory transactionIDFactory = this.createTransactionIDFactory();
        this.transactionController = new TransactionController(transactionIDFactory);
        ConfigurationHelper configurationHelper = new ConfigurationHelper(this, localConfiguration);
        this.configure(configurationHelper);
        this.status = Status.STATUS_ALIVE;
        for (CacheManagerPeerProvider cacheManagerPeerProvider : this.cacheManagerPeerProviders.values()) {
            cacheManagerPeerProvider.init();
        }
        this.cacheManagerEventListenerRegistry.init();
        this.addShutdownHookIfRequired();
        this.cacheManagerTimer = new FailSafeTimer(this.getName());
        this.checkForUpdateIfNeeded(localConfiguration.getUpdateCheck());
        this.mbeanRegistrationProvider = MBEAN_REGISTRATION_PROVIDER_FACTORY.createMBeanRegistrationProvider(localConfiguration);
        this.addConfiguredCaches(configurationHelper);
        try {
            this.mbeanRegistrationProvider.initialize(this, this.terracottaClient.getClusteredInstanceFactory());
        }
        catch (MBeanRegistrationProviderException e) {
            LOG.warn("Failed to initialize the MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), (Throwable)e);
        }
    }

    private boolean isTerracottaRejoinEnabled() {
        TerracottaClientConfiguration terracottaConfiguration = this.configuration.getTerracottaConfiguration();
        return terracottaConfiguration != null && terracottaConfiguration.isRejoin();
    }

    private void validateConfiguration() {
        if (this.isTerracottaRejoinEnabled()) {
            this.validateCacheConfigs(this.configuration.getCacheConfigurations().values());
        }
    }

    private void validateCacheConfigs(Collection<CacheConfiguration> cacheConfigs) {
        boolean invalid = false;
        ArrayList<String> invalidCaches = new ArrayList<String>();
        if (this.isTerracottaRejoinEnabled()) {
            for (CacheConfiguration config : cacheConfigs) {
                if (!config.isTerracottaClustered() || config.getTerracottaConfiguration().isNonstopEnabled()) continue;
                invalid = true;
                invalidCaches.add(config.getName());
            }
        }
        if (invalid) {
            throw new InvalidConfigurationException("Terracotta clustered caches must be nonstop when rejoin is enabled. Invalid caches: " + invalidCaches);
        }
    }

    public String getClusterUUID() {
        if (this.terracottaClient.getClusteredInstanceFactory() != null) {
            return CacheManager.getClientUUID(this.terracottaClient.getClusteredInstanceFactory());
        }
        return "";
    }

    private static String getClientUUID(ClusteredInstanceFactory clusteredInstanceFactory) {
        return clusteredInstanceFactory.getUUID();
    }

    public Store createTerracottaStore(Ehcache cache) {
        return this.getClusteredInstanceFactory(cache).createStore(cache);
    }

    public WriteBehind createTerracottaWriteBehind(Ehcache cache) {
        return this.getClusteredInstanceFactory(cache).createWriteBehind(cache);
    }

    public CacheEventListener createTerracottaEventReplicator(Ehcache cache) {
        return this.getClusteredInstanceFactory(cache).createEventReplicator(cache);
    }

    private ClusteredInstanceFactory getClusteredInstanceFactory(Ehcache cache) {
        ClusteredInstanceFactory clusteredInstanceFactory = this.terracottaClient.getClusteredInstanceFactory();
        if (null == clusteredInstanceFactory) {
            HashMap<String, CacheConfiguration> map = new HashMap<String, CacheConfiguration>(1);
            map.put(cache.getName(), cache.getCacheConfiguration());
            boolean created = this.terracottaClient.createClusteredInstanceFactory(map);
            clusteredInstanceFactory = this.terracottaClient.getClusteredInstanceFactory();
            if (created) {
                try {
                    this.mbeanRegistrationProvider.reinitialize(clusteredInstanceFactory);
                }
                catch (MBeanRegistrationProviderException e) {
                    LOG.warn("Failed to initialize the MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), (Throwable)e);
                }
            }
        }
        return clusteredInstanceFactory;
    }

    private void checkForUpdateIfNeeded(boolean updateCheckNeeded) {
        try {
            if (updateCheckNeeded) {
                UpdateChecker updateChecker = new UpdateChecker();
                this.cacheManagerTimer.scheduleAtFixedRate((TimerTask)updateChecker, 1000L, 604800000L);
            }
        }
        catch (Throwable t) {
            LOG.debug("Failed to set up update checker", t);
        }
    }

    private synchronized Configuration parseConfiguration(String configurationFileName, URL configurationURL, InputStream configurationInputStream) throws CacheException {
        Configuration parsedConfig;
        this.reinitialisationCheck();
        if (configurationFileName != null) {
            LOG.debug("Configuring CacheManager from {}", (Object)configurationFileName);
            parsedConfig = ConfigurationFactory.parseConfiguration(new File(configurationFileName));
        } else if (configurationURL != null) {
            parsedConfig = ConfigurationFactory.parseConfiguration(configurationURL);
        } else if (configurationInputStream != null) {
            parsedConfig = ConfigurationFactory.parseConfiguration(configurationInputStream);
        } else {
            LOG.debug("Configuring ehcache from classpath.");
            parsedConfig = ConfigurationFactory.parseConfiguration();
        }
        return parsedConfig;
    }

    private void configure(ConfigurationHelper configurationHelper) {
        this.diskStorePath = configurationHelper.getDiskStorePath();
        int cachesRequiringDiskStores = configurationHelper.numberOfCachesThatOverflowToDisk() + configurationHelper.numberOfCachesThatAreDiskPersistent();
        if (this.diskStorePath == null && cachesRequiringDiskStores > 0) {
            this.diskStorePath = DiskStoreConfiguration.getDefaultPath();
            LOG.warn("One or more caches require a DiskStore but there is no diskStore element configured. Using the default disk store path of " + DiskStoreConfiguration.getDefaultPath() + ". Please explicitly configure the diskStore element in ehcache.xml.");
        }
        FactoryConfiguration lookupConfiguration = this.configuration.getTransactionManagerLookupConfiguration();
        try {
            Properties properties = PropertyUtil.parseProperties(lookupConfiguration.getProperties(), lookupConfiguration.getPropertySeparator());
            Class<?> transactionManagerLookupClass = Class.forName(lookupConfiguration.getFullyQualifiedClassPath());
            this.transactionManagerLookup = (TransactionManagerLookup)transactionManagerLookupClass.newInstance();
            this.transactionManagerLookup.setProperties(properties);
        }
        catch (Exception e) {
            LOG.error("could not instantiate transaction manager lookup class: {}", (Object)lookupConfiguration.getFullyQualifiedClassPath(), (Object)e);
        }
        this.detectAndFixDiskStorePathConflict(configurationHelper);
        this.cacheManagerEventListenerRegistry.registerListener(configurationHelper.createCacheManagerEventListener());
        this.cacheManagerPeerListeners.putAll(configurationHelper.createCachePeerListeners());
        for (CacheManagerPeerListener cacheManagerPeerListener : this.cacheManagerPeerListeners.values()) {
            this.cacheManagerEventListenerRegistry.registerListener(cacheManagerPeerListener);
        }
        this.detectAndFixCacheManagerPeerListenerConflict(configurationHelper);
        ALL_CACHE_MANAGERS.add(this);
        this.cacheManagerPeerProviders.putAll(configurationHelper.createCachePeerProviders());
        this.defaultCache = configurationHelper.createDefaultCache();
    }

    private void detectAndFixDiskStorePathConflict(ConfigurationHelper configurationHelper) {
        if (this.diskStorePath == null) {
            LOG.debug("No disk store path defined. Skipping disk store path conflict test.");
            return;
        }
        for (CacheManager cacheManager : ALL_CACHE_MANAGERS) {
            if (!this.diskStorePath.equals(cacheManager.diskStorePath)) continue;
            String newDiskStorePath = this.diskStorePath + File.separator + DiskStore.generateUniqueDirectory();
            LOG.warn("Creating a new instance of CacheManager using the diskStorePath \"" + this.diskStorePath + "\" which is already used" + " by an existing CacheManager.\nThe source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "The diskStore path for this CacheManager will be set to " + newDiskStorePath + ".\nTo avoid this" + " warning consider using the CacheManager factory methods to create a singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
            this.diskStorePath = newDiskStorePath;
            break;
        }
    }

    private void detectAndFixCacheManagerPeerListenerConflict(ConfigurationHelper configurationHelper) {
        if (this.cacheManagerPeerListeners == null) {
            return;
        }
        for (CacheManagerPeerListener cacheManagerPeerListener : this.cacheManagerPeerListeners.values()) {
            String uniqueResourceIdentifier = cacheManagerPeerListener.getUniqueResourceIdentifier();
            block1: for (CacheManager cacheManager : ALL_CACHE_MANAGERS) {
                for (CacheManagerPeerListener otherCacheManagerPeerListener : cacheManager.cacheManagerPeerListeners.values()) {
                    String otherUniqueResourceIdentifier;
                    if (otherCacheManagerPeerListener == null || !uniqueResourceIdentifier.equals(otherUniqueResourceIdentifier = otherCacheManagerPeerListener.getUniqueResourceIdentifier())) continue;
                    LOG.warn("Creating a new instance of CacheManager with a CacheManagerPeerListener which has a conflict on a resource that must be unique.\nThe resource is " + uniqueResourceIdentifier + ".\n" + "Attempting automatic resolution. The source of the configuration was " + configurationHelper.getConfigurationBean().getConfigurationSource() + ".\n" + "To avoid this warning consider using the CacheManager factory methods to create a " + "singleton CacheManager " + "or specifying a separate ehcache configuration (ehcache.xml) for each CacheManager instance.");
                    cacheManagerPeerListener.attemptResolutionOfUniqueResourceConflict();
                    continue block1;
                }
            }
        }
    }

    private void addConfiguredCaches(ConfigurationHelper configurationHelper) {
        Set unitialisedCaches = configurationHelper.createCaches();
        for (Ehcache unitialisedCache : unitialisedCaches) {
            this.addCacheNoCheck(unitialisedCache, true);
            List<Ehcache> cacheDecorators = configurationHelper.createCacheDecorators(unitialisedCache);
            for (Ehcache decoratedCache : cacheDecorators) {
                this.addOrReplaceDecoratedCache(unitialisedCache, decoratedCache);
            }
        }
    }

    private void addOrReplaceDecoratedCache(Ehcache underlyingCache, Ehcache decoratedCache) {
        if (decoratedCache.getName().equals(underlyingCache.getName())) {
            this.replaceCacheWithDecoratedCache(underlyingCache, decoratedCache);
        } else {
            this.addDecoratedCache(decoratedCache);
        }
    }

    private void reinitialisationCheck() throws IllegalStateException {
        if (this.diskStorePath != null || this.ehcaches.size() != 0 || this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("Attempt to reinitialise the CacheManager");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create() throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with default config");
                singleton = new CacheManager();
            } else {
                LOG.debug("Attempting to create an existing singleton. Existing singleton returned.");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public static CacheManager getInstance() throws CacheException {
        return CacheManager.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(String configurationFileName) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with config file: {}", (Object)configurationFileName);
                singleton = new CacheManager(configurationFileName);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(URL configurationFileURL) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with config URL: {}", (Object)configurationFileURL);
                singleton = new CacheManager(configurationFileURL);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(InputStream inputStream) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with InputStream");
                singleton = new CacheManager(inputStream);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheManager create(Configuration config) throws CacheException {
        if (singleton != null) {
            return singleton;
        }
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (singleton == null) {
                LOG.debug("Creating new CacheManager with InputStream");
                singleton = new CacheManager(config);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    public Cache getCache(String name) throws IllegalStateException, ClassCastException {
        this.checkStatus();
        return this.ehcaches.get(name) instanceof Cache ? (Cache)this.ehcaches.get(name) : null;
    }

    public Ehcache getEhcache(String name) throws IllegalStateException {
        this.checkStatus();
        return (Ehcache)this.ehcaches.get(name);
    }

    private void addShutdownHookIfRequired() {
        String shutdownHookProperty = System.getProperty(ENABLE_SHUTDOWN_HOOK_PROPERTY);
        boolean enabled = PropertyUtil.parseBoolean(shutdownHookProperty);
        if (!enabled) {
            return;
        }
        LOG.info("The CacheManager shutdown hook is enabled because {} is set to true.", (Object)ENABLE_SHUTDOWN_HOOK_PROPERTY);
        Thread localShutdownHook = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    if (CacheManager.this.status.equals(Status.STATUS_ALIVE)) {
                        CacheManager.this.shutdownHook = null;
                        LOG.info("VM shutting down with the CacheManager still active. Calling shutdown.");
                        CacheManager.this.shutdown();
                    }
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(localShutdownHook);
        this.shutdownHook = localShutdownHook;
    }

    private void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException e) {
                LOG.debug("IllegalStateException due to attempt to remove a shutdownhook while the VM is actually shutting down.", (Throwable)e);
            }
            this.shutdownHook = null;
        }
    }

    public void addCache(String cacheName) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        if (this.ehcaches.get(cacheName) != null) {
            throw new ObjectExistsException("Cache " + cacheName + " already exists");
        }
        Ehcache clonedDefaultCache = this.cloneDefaultCache(cacheName);
        if (clonedDefaultCache == null) {
            throw new CacheException(NO_DEFAULT_CACHE_ERROR_MSG);
        }
        this.addCache(clonedDefaultCache);
        for (Ehcache ehcache : this.createDefaultCacheDecorators(clonedDefaultCache)) {
            this.addOrReplaceDecoratedCache(clonedDefaultCache, ehcache);
        }
    }

    public void addCache(Cache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cache == null) {
            return;
        }
        this.addCache((Ehcache)cache);
    }

    public void addCache(Ehcache cache) throws IllegalStateException, ObjectExistsException, CacheException {
        this.checkStatus();
        if (cache == null) {
            return;
        }
        this.addCacheNoCheck(cache, true);
    }

    public void addDecoratedCache(Ehcache decoratedCache) throws ObjectExistsException {
        this.internalAddDecoratedCache(decoratedCache, true);
    }

    public void addDecoratedCacheIfAbsent(Ehcache decoratedCache) throws ObjectExistsException {
        this.internalAddDecoratedCache(decoratedCache, false);
    }

    private void internalAddDecoratedCache(Ehcache decoratedCache, boolean strict) {
        Ehcache old = this.ehcaches.putIfAbsent(decoratedCache.getName(), decoratedCache);
        if (strict && old != null) {
            throw new ObjectExistsException("Cache " + decoratedCache.getName() + " already exists in the CacheManager");
        }
    }

    private Ehcache addCacheNoCheck(Ehcache cache, boolean strict) throws IllegalStateException, ObjectExistsException, CacheException {
        CacheConfiguration cacheConfig;
        if (this.isTerracottaRejoinEnabled()) {
            this.validateCacheConfigs(Collections.singletonList(cache.getCacheConfiguration()));
        }
        if (cache.getStatus() != Status.STATUS_UNINITIALISED) {
            throw new CacheException("Trying to add an already initialized cache. If you are adding a decorated cache, use CacheManager.addDecoratedCache(Ehcache decoratedCache) instead.");
        }
        Ehcache ehcache = (Ehcache)this.ehcaches.get(cache.getName());
        if (ehcache != null) {
            if (strict) {
                throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
            }
            return ehcache;
        }
        cache.setCacheManager(this);
        if (cache.getCacheConfiguration().getDiskStorePath() == null) {
            cache.setDiskStorePath(this.diskStorePath);
        }
        cache.setTransactionManagerLookup(this.transactionManagerLookup);
        Map<String, CacheConfiguration> configMap = this.configuration.getCacheConfigurations();
        if (!configMap.containsKey(cache.getName()) && (cacheConfig = cache.getCacheConfiguration()) != null) {
            this.configuration.addCache(cacheConfig);
        }
        cache.initialise();
        if (!this.allowsDynamicCacheConfig) {
            cache.disableDynamicFeatures();
        }
        try {
            cache.bootstrap();
        }
        catch (CacheException e) {
            LOG.warn("Cache " + cache.getName() + "requested bootstrap but a CacheException occured. " + e.getMessage(), (Throwable)e);
        }
        ehcache = this.ehcaches.putIfAbsent(cache.getName(), cache);
        if (ehcache != null) {
            if (strict) {
                throw new ObjectExistsException("Cache " + cache.getName() + " already exists");
            }
            return ehcache;
        }
        if (this.status.equals(Status.STATUS_ALIVE)) {
            this.cacheManagerEventListenerRegistry.notifyCacheAdded(cache.getName());
        }
        return cache;
    }

    public boolean cacheExists(String cacheName) throws IllegalStateException {
        this.checkStatus();
        return this.ehcaches.get(cacheName) != null;
    }

    public void removalAll() {
        String[] cacheNames;
        for (String cacheName : cacheNames = this.getCacheNames()) {
            this.removeCache(cacheName);
        }
    }

    public void removeCache(String cacheName) throws IllegalStateException {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return;
        }
        Ehcache cache = (Ehcache)this.ehcaches.remove(cacheName);
        if (cache != null && cache.getStatus().equals(Status.STATUS_ALIVE)) {
            cache.dispose();
            this.configuration.getCacheConfigurations().remove(cacheName);
            this.cacheManagerEventListenerRegistry.notifyCacheRemoved(cache.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Class<CacheManager> clazz = CacheManager.class;
        synchronized (CacheManager.class) {
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                LOG.debug("CacheManager already shutdown");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            for (CacheManagerPeerProvider cacheManagerPeerProvider : this.cacheManagerPeerProviders.values()) {
                if (cacheManagerPeerProvider == null) continue;
                cacheManagerPeerProvider.dispose();
            }
            if (this.cacheManagerTimer != null) {
                this.cacheManagerTimer.cancel();
                this.cacheManagerTimer.purge();
            }
            this.cacheManagerEventListenerRegistry.dispose();
            Class<CacheManager> clazz2 = CacheManager.class;
            synchronized (CacheManager.class) {
                ALL_CACHE_MANAGERS.remove(this);
                for (Ehcache cache : this.ehcaches.values()) {
                    if (cache == null) continue;
                    cache.dispose();
                }
                if (this.defaultCache != null) {
                    this.defaultCache.dispose();
                }
                this.status = Status.STATUS_SHUTDOWN;
                XARequestProcessor.shutdown();
                if (this == singleton) {
                    singleton = null;
                }
                this.terracottaClient.shutdown();
                this.transactionController = null;
                this.removeShutdownHook();
                CacheManagerExecutorServiceFactory.getInstance().shutdown(this);
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
            return;
        }
    }

    public String[] getCacheNames() throws IllegalStateException {
        this.checkStatus();
        String[] list = new String[this.ehcaches.size()];
        return this.ehcaches.keySet().toArray(list);
    }

    protected void checkStatus() {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            if (this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("The CacheManager has not yet been initialised. It cannot be used yet.");
            }
            if (this.status.equals(Status.STATUS_SHUTDOWN)) {
                throw new IllegalStateException("The CacheManager has been shut down. It can no longer be used.");
            }
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void clearAll() throws CacheException {
        String[] cacheNames = this.getCacheNames();
        LOG.debug("Clearing all caches");
        for (String cacheName : cacheNames) {
            Ehcache cache = this.getEhcache(cacheName);
            cache.removeAll();
        }
    }

    public void clearAllStartingWith(String prefix) throws CacheException {
        if (prefix == null || prefix.length() == 0) {
            return;
        }
        for (Map.Entry o : this.ehcaches.entrySet()) {
            Map.Entry entry = o;
            String cacheName = (String)entry.getKey();
            if (!cacheName.startsWith(prefix)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Clearing cache named '" + cacheName + "' (matches '" + prefix + "' prefix");
            }
            ((Ehcache)entry.getValue()).removeAll();
        }
    }

    public CacheManagerPeerProvider getCacheManagerPeerProvider(String scheme) {
        return this.cacheManagerPeerProviders.get(scheme);
    }

    public Map<String, CacheManagerPeerProvider> getCacheManagerPeerProviders() {
        return Collections.unmodifiableMap(this.cacheManagerPeerProviders);
    }

    public CacheManagerPeerListener getCachePeerListener(String scheme) {
        return this.cacheManagerPeerListeners.get(scheme);
    }

    public CacheManagerEventListener getCacheManagerEventListener() {
        return this.cacheManagerEventListenerRegistry;
    }

    public void setCacheManagerEventListener(CacheManagerEventListener cacheManagerEventListener) {
        this.getCacheManagerEventListenerRegistry().registerListener(cacheManagerEventListener);
    }

    public CacheManagerEventListenerRegistry getCacheManagerEventListenerRegistry() {
        return this.cacheManagerEventListenerRegistry;
    }

    public void replaceCacheWithDecoratedCache(Ehcache ehcache, Ehcache decoratedCache) throws CacheException {
        if (!ehcache.equals(decoratedCache)) {
            throw new CacheException("Cannot replace " + decoratedCache.getName() + " It does not equal the incumbent cache.");
        }
        String cacheName = ehcache.getName();
        if (!this.ehcaches.replace(cacheName, ehcache, decoratedCache)) {
            if (this.cacheExists(cacheName)) {
                throw new CacheException("Cache '" + ehcache.getName() + "' managed with this CacheManager doesn't match!");
            }
            throw new CacheException("Cache '" + cacheName + "' isn't associated with this manager (anymore?)");
        }
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return super.toString();
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public void setName(String name) {
        this.name = name;
        try {
            this.mbeanRegistrationProvider.reinitialize(this.terracottaClient.getClusteredInstanceFactory());
        }
        catch (MBeanRegistrationProviderException e) {
            throw new CacheException("Problem in reinitializing MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), e);
        }
    }

    public String toString() {
        return this.getName();
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public FailSafeTimer getTimer() {
        return this.cacheManagerTimer;
    }

    public CacheCluster getCluster(ClusterScheme scheme) throws ClusterSchemeNotAvailableException {
        switch (scheme) {
            case TERRACOTTA: {
                if (null == this.terracottaClient.getClusteredInstanceFactory()) {
                    throw new ClusterSchemeNotAvailableException(ClusterScheme.TERRACOTTA, "Terracotta cluster scheme is not available");
                }
                return this.terracottaClient.getCacheCluster();
            }
        }
        return NoopCacheCluster.INSTANCE;
    }

    public String getOriginalConfigurationText() {
        if (this.configuration.getConfigurationSource() == null) {
            return "Originally configured programmatically. No original configuration source text.";
        }
        Configuration originalConfiguration = this.configuration.getConfigurationSource().createConfiguration();
        return ConfigurationUtil.generateCacheManagerConfigurationText(originalConfiguration);
    }

    public String getActiveConfigurationText() {
        return ConfigurationUtil.generateCacheManagerConfigurationText(this.configuration);
    }

    public String getOriginalConfigurationText(String cacheName) throws CacheException {
        if (this.configuration.getConfigurationSource() == null) {
            return "Originally configured programmatically. No original configuration source text.";
        }
        Configuration originalConfiguration = this.configuration.getConfigurationSource().createConfiguration();
        CacheConfiguration cacheConfiguration = originalConfiguration.getCacheConfigurations().get(cacheName);
        if (cacheConfiguration == null) {
            throw new CacheException("Cache with name '" + cacheName + "' does not exist in the original configuration");
        }
        return ConfigurationUtil.generateCacheConfigurationText(cacheConfiguration);
    }

    public String getActiveConfigurationText(String cacheName) throws CacheException {
        CacheConfiguration config = this.configuration.getCacheConfigurations().get(cacheName);
        if (config == null) {
            throw new CacheException("Cache with name '" + cacheName + "' does not exist");
        }
        return ConfigurationUtil.generateCacheConfigurationText(config);
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public int hashCode() {
        if (this.name != null) {
            return this.name.hashCode();
        }
        return super.hashCode();
    }

    public Ehcache addCacheIfAbsent(Ehcache cache) {
        this.checkStatus();
        return cache == null ? null : this.addCacheNoCheck(cache, false);
    }

    public Ehcache addCacheIfAbsent(String cacheName) {
        this.checkStatus();
        if (cacheName == null || cacheName.length() == 0) {
            return null;
        }
        Ehcache ehcache = (Ehcache)this.ehcaches.get(cacheName);
        if (ehcache == null) {
            Ehcache clonedDefaultCache = this.cloneDefaultCache(cacheName);
            if (clonedDefaultCache == null) {
                throw new CacheException(NO_DEFAULT_CACHE_ERROR_MSG);
            }
            this.addCacheIfAbsent(clonedDefaultCache);
            for (Ehcache createdCache : this.createDefaultCacheDecorators(clonedDefaultCache)) {
                this.addOrReplaceDecoratedCache(clonedDefaultCache, createdCache);
            }
        }
        return (Ehcache)this.ehcaches.get(cacheName);
    }

    private Ehcache cloneDefaultCache(String cacheName) {
        Ehcache cache;
        if (this.defaultCache == null) {
            return null;
        }
        try {
            cache = (Ehcache)this.defaultCache.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CacheException("Failure cloning default cache. Initial cause was " + e.getMessage(), e);
        }
        if (cache != null) {
            cache.setName(cacheName);
        }
        return cache;
    }

    private List<Ehcache> createDefaultCacheDecorators(Ehcache underlyingCache) {
        return ConfigurationHelper.createDefaultCacheDecorators(underlyingCache, this.configuration.getDefaultCacheConfiguration());
    }

    public TransactionController getTransactionController() {
        return this.transactionController;
    }

    TransactionIDFactory createTransactionIDFactory() {
        TransactionIDFactory transactionIDFactory = this.terracottaClient.getClusteredInstanceFactory() != null ? this.terracottaClient.getClusteredInstanceFactory().createTransactionIDFactory(this.getClusterUUID()) : new TransactionIDFactoryImpl();
        return transactionIDFactory;
    }

    SoftLockFactory createSoftLockFactory(Ehcache cache) {
        SoftLockFactory softLockFactory;
        if (cache.getCacheConfiguration().isTerracottaClustered()) {
            softLockFactory = this.getClusteredInstanceFactory(cache).getOrCreateSoftLockFactory(cache.getName());
        } else {
            softLockFactory = (SoftLockFactory)this.softLockFactories.get(cache.getName());
            if (softLockFactory == null) {
                softLockFactory = new ReadCommittedSoftLockFactoryImpl(cache.getName());
                SoftLockFactory old = this.softLockFactories.putIfAbsent(cache.getName(), softLockFactory);
                if (old != null) {
                    softLockFactory = old;
                }
            }
        }
        return softLockFactory;
    }

    private void clusterRejoinStarted() {
        for (Ehcache cache : this.ehcaches.values()) {
            if (!(cache instanceof Cache) || !cache.getCacheConfiguration().isTerracottaClustered()) continue;
            ((Cache)cache).clusterRejoinStarted();
        }
        CacheManagerExecutorServiceFactory.getInstance().shutdown(this);
    }

    private void clusterRejoinComplete() {
        CacheManagerExecutorServiceFactory.getInstance().getOrCreateNonstopExecutorService(this);
        for (Ehcache cache : this.ehcaches.values()) {
            if (!(cache instanceof Cache) || !cache.getCacheConfiguration().isTerracottaClustered()) continue;
            ((Cache)cache).clusterRejoinComplete();
        }
        try {
            this.mbeanRegistrationProvider.reinitialize(this.terracottaClient.getClusteredInstanceFactory());
        }
        catch (MBeanRegistrationProviderException e) {
            throw new CacheException("Problem in reinitializing MBeanRegistrationProvider - " + this.mbeanRegistrationProvider.getClass().getName(), e);
        }
        this.transactionController = new TransactionController(this.createTransactionIDFactory());
    }

    static {
        MBEAN_REGISTRATION_PROVIDER_FACTORY = new MBeanRegistrationProviderFactoryImpl();
    }
}

