/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.CacheQuery;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.LoaderTimeoutException;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.bootstrap.BootstrapCacheLoaderFactory;
import net.sf.ehcache.cluster.CacheCluster;
import net.sf.ehcache.cluster.ClusterScheme;
import net.sf.ehcache.cluster.ClusterSchemeNotAvailableException;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.StripedReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.NonstopConfiguration;
import net.sf.ehcache.config.SearchAttribute;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.constructs.nonstop.CacheManagerExecutorServiceFactory;
import net.sf.ehcache.constructs.nonstop.NonstopActiveDelegateHolder;
import net.sf.ehcache.constructs.nonstop.NonstopExecutorService;
import net.sf.ehcache.constructs.nonstop.store.NonstopStore;
import net.sf.ehcache.constructs.nonstop.store.NonstopStoreImpl;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.CacheEventListenerFactory;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.extension.CacheExtensionFactory;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.loader.CacheLoaderFactory;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;
import net.sf.ehcache.search.attribute.AttributeExtractor;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsWrapper;
import net.sf.ehcache.statistics.sampled.SampledCacheStatistics;
import net.sf.ehcache.statistics.sampled.SampledCacheStatisticsWrapper;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.LegacyStoreWrapper;
import net.sf.ehcache.store.LruMemoryStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.StoreListener;
import net.sf.ehcache.store.StoreQuery;
import net.sf.ehcache.store.TerracottaStore;
import net.sf.ehcache.store.compound.ImmutableValueElementCopyStrategy;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.store.compound.StoreUpdateException;
import net.sf.ehcache.store.compound.impl.DiskPersistentStore;
import net.sf.ehcache.store.compound.impl.MemoryOnlyStore;
import net.sf.ehcache.store.compound.impl.OverflowToDiskStore;
import net.sf.ehcache.terracotta.TerracottaClient;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;
import net.sf.ehcache.transaction.SoftLockFactory;
import net.sf.ehcache.transaction.TransactionIDFactory;
import net.sf.ehcache.transaction.local.JtaLocalTransactionStore;
import net.sf.ehcache.transaction.local.LocalTransactionStore;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResourceImpl;
import net.sf.ehcache.transaction.xa.XATransactionStore;
import net.sf.ehcache.util.ClassLoaderUtil;
import net.sf.ehcache.util.NamedThreadFactory;
import net.sf.ehcache.util.PropertyUtil;
import net.sf.ehcache.util.TimeUtil;
import net.sf.ehcache.util.VmUtils;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.CacheWriterFactory;
import net.sf.ehcache.writer.CacheWriterManager;
import net.sf.ehcache.writer.CacheWriterManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache
implements Ehcache,
StoreListener {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final String NET_SF_EHCACHE_DISABLED = "net.sf.ehcache.disabled";
    public static final String NET_SF_EHCACHE_USE_CLASSIC_LRU = "net.sf.ehcache.use.classic.lru";
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final String OFF_HEAP_STORE_CLASSNAME = "net.sf.ehcache.store.offheap.OffHeapStore";
    private static final Logger LOG = LoggerFactory.getLogger((String)Cache.class.getName());
    private static InetAddress localhost;
    private static final int BACK_OFF_TIME_MILLIS = 50;
    private static final int EXECUTOR_KEEP_ALIVE_TIME = 60000;
    private static final int EXECUTOR_MAXIMUM_POOL_SIZE;
    private static final int EXECUTOR_CORE_POOL_SIZE = 1;
    private volatile boolean disabled = Boolean.getBoolean("net.sf.ehcache.disabled");
    private final boolean useClassicLru = Boolean.getBoolean("net.sf.ehcache.use.classic.lru");
    private volatile String diskStorePath;
    private volatile CacheStatus cacheStatus = new CacheStatus();
    private volatile CacheConfiguration configuration;
    private volatile Store compoundStore;
    private volatile CacheLockProvider lockProvider;
    private volatile RegisteredEventListeners registeredEventListeners;
    private volatile List<CacheExtension> registeredCacheExtensions;
    private volatile String guid;
    private volatile CacheManager cacheManager;
    private volatile BootstrapCacheLoader bootstrapCacheLoader;
    private volatile CacheExceptionHandler cacheExceptionHandler;
    private volatile List<CacheLoader> registeredCacheLoaders;
    private volatile CacheWriterManager cacheWriterManager;
    private final AtomicBoolean cacheWriterManagerInitFlag = new AtomicBoolean(false);
    private final ReentrantLock cacheWriterManagerInitLock = new ReentrantLock();
    private volatile CacheWriter registeredCacheWriter;
    private volatile ExecutorService executorService;
    private volatile LiveCacheStatisticsWrapper liveCacheStatisticsData;
    private volatile SampledCacheStatisticsWrapper sampledCacheStatistics;
    private volatile TransactionManagerLookup transactionManagerLookup;
    private volatile boolean allowDisable = true;
    private volatile PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private volatile ElementValueComparator elementValueComparator;
    private volatile NonstopActiveDelegateHolderImpl nonstopActiveDelegateHolder;

    public Cache(CacheConfiguration cacheConfiguration) {
        this(cacheConfiguration, null, null);
    }

    public Cache(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        this.cacheStatus.changeState(Status.STATUS_UNINITIALISED);
        this.configuration = cacheConfiguration.clone();
        this.configuration.validateCompleteConfiguration();
        this.elementValueComparator = cacheConfiguration.getElementValueComparatorConfiguration().getElementComparatorInstance();
        this.guid = this.createGuid();
        this.diskStorePath = cacheConfiguration.getDiskStorePath();
        this.registeredEventListeners = registeredEventListeners == null ? new RegisteredEventListeners(this) : registeredEventListeners;
        this.registeredCacheExtensions = new CopyOnWriteArrayList<CacheExtension>();
        this.registeredCacheLoaders = new CopyOnWriteArrayList<CacheLoader>();
        this.liveCacheStatisticsData = new LiveCacheStatisticsWrapper(this);
        this.sampledCacheStatistics = new SampledCacheStatisticsWrapper();
        RegisteredEventListeners listeners = this.getCacheEventNotificationService();
        Cache.registerCacheListeners(this.configuration, listeners);
        Cache.registerCacheExtensions(this.configuration, this);
        this.bootstrapCacheLoader = null == bootstrapCacheLoader ? Cache.createBootstrapCacheLoader(this.configuration.getBootstrapCacheLoaderFactoryConfiguration()) : bootstrapCacheLoader;
        Cache.registerCacheLoaders(this.configuration, this);
        Cache.registerCacheWriter(this.configuration, this);
        this.nonstopActiveDelegateHolder = new NonstopActiveDelegateHolderImpl(this);
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(new CacheConfiguration(name, maxElementsInMemory).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds));
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds) {
        this(new CacheConfiguration(name, maxElementsInMemory).overflowToDisk(overflowToDisk).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds));
        LOG.warn("An API change between ehcache-1.1 and ehcache-1.2 results in the persistence path being set to " + DiskStoreConfiguration.getDefaultPath() + " when the ehcache-1.1 constructor is used. " + "Please change to the 1.2 constructor.");
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).diskStorePath(diskStorePath).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds), registeredEventListeners, null);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).diskStorePath(diskStorePath).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).diskStorePath(diskStorePath).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).diskStorePath(diskStorePath).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk).diskSpoolBufferSizeMB(diskSpoolBufferSizeMB), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB, boolean clearOnFlush) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).diskStorePath(diskStorePath).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk).diskSpoolBufferSizeMB(diskSpoolBufferSizeMB).clearOnFlush(clearOnFlush), registeredEventListeners, bootstrapCacheLoader);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB, boolean clearOnFlush, boolean isTerracottaClustered, String terracottaValueMode, boolean terracottaCoherentReads) {
        this(new CacheConfiguration(name, maxElementsInMemory).memoryStoreEvictionPolicy(memoryStoreEvictionPolicy).overflowToDisk(overflowToDisk).diskStorePath(diskStorePath).eternal(eternal).timeToLiveSeconds(timeToLiveSeconds).timeToIdleSeconds(timeToIdleSeconds).diskPersistent(diskPersistent).diskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds).maxElementsOnDisk(maxElementsOnDisk).diskSpoolBufferSizeMB(diskSpoolBufferSizeMB).clearOnFlush(clearOnFlush).terracotta(new TerracottaConfiguration().clustered(isTerracottaClustered).valueMode(terracottaValueMode).coherentReads(terracottaCoherentReads)), registeredEventListeners, bootstrapCacheLoader);
    }

    private static void registerCacheListeners(CacheConfiguration cacheConfiguration, RegisteredEventListeners registeredEventListeners) {
        List cacheEventListenerConfigurations = cacheConfiguration.getCacheEventListenerConfigurations();
        for (Object cacheEventListenerConfiguration : cacheEventListenerConfigurations) {
            CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheEventListenerFactoryConfiguration)cacheEventListenerConfiguration;
            CacheEventListener cacheEventListener = Cache.createCacheEventListener(factoryConfiguration);
            registeredEventListeners.registerListener(cacheEventListener, factoryConfiguration.getListenFor());
        }
    }

    private static void registerCacheExtensions(CacheConfiguration cacheConfiguration, Ehcache cache) {
        List cacheExtensionConfigurations = cacheConfiguration.getCacheExtensionConfigurations();
        for (Object cacheExtensionConfiguration : cacheExtensionConfigurations) {
            CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheExtensionFactoryConfiguration)cacheExtensionConfiguration;
            CacheExtension cacheExtension = Cache.createCacheExtension(factoryConfiguration, cache);
            cache.registerCacheExtension(cacheExtension);
        }
    }

    private static void registerCacheLoaders(CacheConfiguration cacheConfiguration, Ehcache cache) {
        List cacheLoaderConfigurations = cacheConfiguration.getCacheLoaderConfigurations();
        for (Object cacheLoaderConfiguration : cacheLoaderConfigurations) {
            CacheConfiguration.CacheLoaderFactoryConfiguration factoryConfiguration = (CacheConfiguration.CacheLoaderFactoryConfiguration)cacheLoaderConfiguration;
            CacheLoader cacheLoader = Cache.createCacheLoader(factoryConfiguration, cache);
            cache.registerCacheLoader(cacheLoader);
        }
    }

    private static void registerCacheWriter(CacheConfiguration cacheConfiguration, Ehcache cache) {
        CacheWriterConfiguration config = cacheConfiguration.getCacheWriterConfiguration();
        if (config != null) {
            CacheWriter cacheWriter = Cache.createCacheWriter(config, cache);
            cache.registerCacheWriter(cacheWriter);
        }
    }

    private static CacheEventListener createCacheEventListener(CacheConfiguration.CacheEventListenerFactoryConfiguration factoryConfiguration) {
        String className = null;
        CacheEventListener cacheEventListener = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheEventListener factory not configured. Skipping...");
        } else {
            CacheEventListenerFactory factory = (CacheEventListenerFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheEventListener = factory.createCacheEventListener(properties);
        }
        return cacheEventListener;
    }

    private static CacheExtension createCacheExtension(CacheConfiguration.CacheExtensionFactoryConfiguration factoryConfiguration, Ehcache cache) {
        String className = null;
        CacheExtension cacheExtension = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheExtension factory not configured. Skipping...");
        } else {
            CacheExtensionFactory factory = (CacheExtensionFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheExtension = factory.createCacheExtension(cache, properties);
        }
        return cacheExtension;
    }

    private static CacheLoader createCacheLoader(CacheConfiguration.CacheLoaderFactoryConfiguration factoryConfiguration, Ehcache cache) {
        String className = null;
        CacheLoader cacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className == null) {
            LOG.debug("CacheLoader factory not configured. Skipping...");
        } else {
            CacheLoaderFactory factory = (CacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            cacheLoader = factory.createCacheLoader(cache, properties);
        }
        return cacheLoader;
    }

    private static CacheWriter createCacheWriter(CacheWriterConfiguration config, Ehcache cache) {
        String className = null;
        CacheWriter cacheWriter = null;
        CacheWriterConfiguration.CacheWriterFactoryConfiguration factoryConfiguration = config.getCacheWriterFactoryConfiguration();
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (null == className) {
            LOG.debug("CacheWriter factory not configured. Skipping...");
        } else {
            CacheWriterFactory factory = (CacheWriterFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            if (null == properties) {
                properties = new Properties();
            }
            cacheWriter = factory.createCacheWriter(cache, properties);
        }
        return cacheWriter;
    }

    private static final BootstrapCacheLoader createBootstrapCacheLoader(CacheConfiguration.BootstrapCacheLoaderFactoryConfiguration factoryConfiguration) throws CacheException {
        String className = null;
        BootstrapCacheLoader bootstrapCacheLoader = null;
        if (factoryConfiguration != null) {
            className = factoryConfiguration.getFullyQualifiedClassPath();
        }
        if (className != null && className.length() != 0) {
            BootstrapCacheLoaderFactory factory = (BootstrapCacheLoaderFactory)ClassLoaderUtil.createNewInstance(className);
            Properties properties = PropertyUtil.parseProperties(factoryConfiguration.getProperties(), factoryConfiguration.getPropertySeparator());
            return factory.createBootstrapCacheLoader(properties);
        }
        LOG.debug("No BootstrapCacheLoaderFactory class specified. Skipping...");
        return bootstrapCacheLoader;
    }

    public TransactionManagerLookup getTransactionManagerLookup() {
        return this.transactionManagerLookup;
    }

    @Override
    public void setTransactionManagerLookup(TransactionManagerLookup lookup) {
        TransactionManagerLookup oldValue = this.getTransactionManagerLookup();
        this.transactionManagerLookup = lookup;
        this.firePropertyChange("TransactionManagerLookup", oldValue, lookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() {
        Cache cache = this;
        synchronized (cache) {
            Object context;
            SoftLockFactory softLockFactory;
            Store store;
            ReadWriteCopyStrategy<Element> copyStrategy;
            block40: {
                if (!this.cacheStatus.canInitialize()) {
                    throw new IllegalStateException("Cannot initialise the " + this.configuration.getName() + " cache because its status is not STATUS_UNINITIALISED");
                }
                if (this.configuration.getMaxElementsInMemory() == 0) {
                    LOG.warn("Cache: " + this.configuration.getName() + " has a maxElementsInMemory of 0.  " + "In Ehcache 2.0 this has been changed to mean a store" + " with no capacity limit. Set it to 1 if you want" + " no elements cached in memory");
                }
                copyStrategy = null;
                if (this.configuration.getTransactionalMode().isTransactional()) {
                    copyStrategy = this.configuration.getCopyStrategyConfiguration().getCopyStrategyInstance();
                    this.configuration.getCopyStrategyConfiguration().setCopyStrategyInstance(new ImmutableValueElementCopyStrategy());
                }
                if (this.configuration.getTransactionalMode().isTransactional() && this.configuration.isTerracottaClustered() && this.configuration.getTerracottaConfiguration().getValueMode() != TerracottaConfiguration.ValueMode.SERIALIZATION) {
                    throw new CacheException("To be transactional, a Terracotta clustered cache needs to be in Serialization value mode");
                }
                if (this.configuration.isOverflowToOffHeap()) {
                    try {
                        Class storeClass = ClassLoaderUtil.loadClass(OFF_HEAP_STORE_CLASSNAME);
                        try {
                            store = (Store)storeClass.getMethod("create", Ehcache.class, String.class).invoke(null, this, this.diskStorePath);
                            break block40;
                        }
                        catch (NoSuchMethodException e) {
                            throw new CacheException("Cache: " + this.configuration.getName() + " cannot find static factory" + " method create(Ehcache, String)" + " in store class " + OFF_HEAP_STORE_CLASSNAME, e);
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof CacheException) {
                                throw (CacheException)cause;
                            }
                            throw new CacheException("Cache: " + this.configuration.getName() + " cannot instantiate store " + OFF_HEAP_STORE_CLASSNAME, cause);
                        }
                        catch (IllegalAccessException e) {
                            throw new CacheException("Cache: " + this.configuration.getName() + " cannot instantiate store " + OFF_HEAP_STORE_CLASSNAME, e);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new CacheException("Cache " + this.configuration.getName() + " cannot be configured because the off-heap store class could not be found. " + "You must use an enterprise version of Ehcache to successfully enable overflowToOffHeap.");
                    }
                }
                if (this.isTerracottaClustered()) {
                    Store tempStore;
                    TerracottaConfiguration.Consistency consistency = this.getCacheConfiguration().getTerracottaConfiguration().getConsistency();
                    boolean coherent = this.getCacheConfiguration().getTerracottaConfiguration().isCoherent();
                    if (this.getCacheConfiguration().getTerracottaConfiguration().isSynchronousWrites() && consistency == TerracottaConfiguration.Consistency.EVENTUAL) {
                        throw new InvalidConfigurationException("Terracotta clustered caches with eventual consistency and synchronous writes are not supported yet. You can fix this by either making the cache in 'strong' consistency mode (<terracotta consistency=\"strong\"/>) or turning off synchronous writes.");
                    }
                    if (this.getCacheConfiguration().getTransactionalMode().isTransactional() && consistency == TerracottaConfiguration.Consistency.EVENTUAL) {
                        throw new InvalidConfigurationException("Consistency should be " + (Object)((Object)TerracottaConfiguration.Consistency.STRONG) + " when cache is configured with transactions enabled. " + "You can fix this by either making the cache in 'strong' consistency mode " + "(<terracotta consistency=\"strong\"/>) or turning off transactions.");
                    }
                    if (this.getCacheConfiguration().getTransactionalMode().isTransactional() && this.getCacheConfiguration().getTerracottaConfiguration().isNonstopEnabled()) {
                        LOG.warn("Cache: " + this.configuration.getName() + " configured both NonStop and transactional." + " NonStop features won't work for this cache!");
                    }
                    if (coherent && consistency == TerracottaConfiguration.Consistency.EVENTUAL || !coherent && consistency == TerracottaConfiguration.Consistency.STRONG) {
                        throw new InvalidConfigurationException("Coherent and consistency attribute values are conflicting. Please remove the coherent attribute as its deprecated.");
                    }
                    if (!this.getCacheConfiguration().getTerracottaConfiguration().isStorageStrategySet()) {
                        this.getCacheConfiguration().getTerracottaConfiguration().storageStrategy(TerracottaClient.getTerracottaDefaultStrategyForCurrentRuntime(this.getCacheConfiguration()));
                    }
                    if (!((tempStore = this.cacheManager.createTerracottaStore(this)) instanceof TerracottaStore)) {
                        throw new CacheException("CacheManager should create instances of TerracottaStore for Terracotta Clustered caches instead of - " + (tempStore == null ? "null" : tempStore.getClass().getName()));
                    }
                    TerracottaStore terracottaStore = (TerracottaStore)tempStore;
                    NonstopConfiguration nonstopConfig = this.getCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration();
                    if (nonstopConfig != null) {
                        nonstopConfig.freezeConfig();
                    }
                    if (this.getCacheConfiguration().getTerracottaConfiguration().isNonstopEnabled()) {
                        this.nonstopActiveDelegateHolder.terracottaStoreInitialized(terracottaStore);
                        store = this.nonstopActiveDelegateHolder.getNonstopStore();
                    } else {
                        store = terracottaStore;
                    }
                } else if (this.useClassicLru && this.configuration.getMemoryStoreEvictionPolicy().equals(MemoryStoreEvictionPolicy.LRU)) {
                    DiskStore disk = this.createDiskStore();
                    store = new LegacyStoreWrapper(new LruMemoryStore(this, disk), disk, this.registeredEventListeners, this.configuration);
                } else {
                    store = this.configuration.isDiskPersistent() ? DiskPersistentStore.create(this, this.diskStorePath) : (this.configuration.isOverflowToDisk() ? OverflowToDiskStore.create(this, this.diskStorePath) : MemoryOnlyStore.create(this, this.diskStorePath));
                }
            }
            if (this.configuration.isXaStrictTransactional()) {
                if (this.transactionManagerLookup.getTransactionManager() == null) {
                    throw new CacheException("You've configured cache " + this.cacheManager.getName() + "." + this.configuration.getName() + " to be transactional, but no TransactionManager could be found!");
                }
                if (this.configuration.isTerracottaClustered()) {
                    this.configuration.getTerracottaConfiguration().setCacheXA(true);
                }
                softLockFactory = this.cacheManager.createSoftLockFactory(this);
                TransactionIDFactory transactionIDFactory = this.cacheManager.createTransactionIDFactory();
                EhcacheXAResourceImpl xaResource = new EhcacheXAResourceImpl(this, store, this.transactionManagerLookup, softLockFactory, transactionIDFactory);
                this.transactionManagerLookup.register(xaResource);
                this.compoundStore = new XATransactionStore(this.transactionManagerLookup, softLockFactory, transactionIDFactory, this, store, copyStrategy);
            } else if (this.configuration.isXaTransactional()) {
                softLockFactory = this.cacheManager.createSoftLockFactory(this);
                LocalTransactionStore localTransactionStore = new LocalTransactionStore(this.getCacheManager().getTransactionController(), softLockFactory, this, store, copyStrategy);
                this.compoundStore = new JtaLocalTransactionStore(localTransactionStore, this.transactionManagerLookup, this.cacheManager.getTransactionController());
            } else if (this.configuration.isLocalTransactional()) {
                softLockFactory = this.cacheManager.createSoftLockFactory(this);
                this.compoundStore = new LocalTransactionStore(this.getCacheManager().getTransactionController(), softLockFactory, this, store, copyStrategy);
            } else {
                this.compoundStore = store;
            }
            HashMap<String, AttributeExtractor> extractors = new HashMap<String, AttributeExtractor>();
            for (SearchAttribute sa : this.configuration.getSearchAttributes().values()) {
                extractors.put(sa.getName(), sa.constructExtractor());
            }
            this.compoundStore.setAttributeExtractors(extractors);
            this.cacheWriterManager = this.configuration.getCacheWriterConfiguration().getWriteMode().createWriterManager(this);
            this.initialiseCacheWriterManager(false);
            this.cacheStatus.changeState(Status.STATUS_ALIVE);
            this.initialiseRegisteredCacheExtensions();
            this.initialiseRegisteredCacheLoaders();
            this.initialiseRegisteredCacheWriter();
            this.getCacheEventNotificationService().registerListener(this.liveCacheStatisticsData);
            this.liveCacheStatisticsData.setStatisticsAccuracy(1);
            this.liveCacheStatisticsData.setStatisticsEnabled(this.configuration.getStatistics());
            this.registerCacheUsageListener(this.sampledCacheStatistics);
            if (this.isTerracottaClustered()) {
                this.cacheManager.createTerracottaEventReplicator(this);
            }
            this.lockProvider = (context = this.compoundStore.getInternalContext()) instanceof CacheLockProvider ? (CacheLockProvider)context : new StripedReadWriteLockSync(2048);
        }
        this.compoundStore.addStoreListener(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialised cache: " + this.configuration.getName());
        }
        if (this.disabled) {
            LOG.warn("Cache: " + this.configuration.getName() + " is disabled because the " + NET_SF_EHCACHE_DISABLED + " property was set to true. No elements will be added to the cache.");
        }
    }

    private CacheCluster getCacheCluster() {
        CacheCluster cacheCluster;
        try {
            cacheCluster = this.getCacheManager().getCluster(ClusterScheme.TERRACOTTA);
        }
        catch (ClusterSchemeNotAvailableException e) {
            LOG.info("Terracotta ClusterScheme is not available, using ClusterScheme.NONE");
            cacheCluster = this.getCacheManager().getCluster(ClusterScheme.NONE);
        }
        return cacheCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialiseCacheWriterManager(boolean imperative) throws CacheException {
        if (!this.cacheWriterManagerInitFlag.get()) {
            this.cacheWriterManagerInitLock.lock();
            try {
                if (!this.cacheWriterManagerInitFlag.get()) {
                    if (this.cacheWriterManager != null && this.registeredCacheWriter != null) {
                        this.cacheWriterManager.init(this);
                        this.cacheWriterManagerInitFlag.set(true);
                    } else if (imperative) {
                        throw new CacheException("Cache: " + this.configuration.getName() + " was being used with cache writer " + "features, but it wasn't properly registered beforehand.");
                    }
                }
            }
            finally {
                this.cacheWriterManagerInitLock.unlock();
            }
        }
    }

    @Override
    public CacheWriterManager getWriterManager() {
        return this.cacheWriterManager;
    }

    protected DiskStore createDiskStore() {
        if (this.isDiskStore()) {
            return DiskStore.create(this, this.diskStorePath);
        }
        return null;
    }

    protected boolean isDiskStore() {
        return this.configuration.isOverflowToDisk() || this.configuration.isDiskPersistent();
    }

    public boolean isTerracottaClustered() {
        return this.configuration.isTerracottaClustered();
    }

    @Override
    public void bootstrap() {
        if (!this.disabled && this.bootstrapCacheLoader != null) {
            this.bootstrapCacheLoader.load(this);
        }
    }

    @Override
    public final void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.put(element, false);
    }

    @Override
    public final void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.putInternal(element, doNotNotifyCacheReplicators, false);
    }

    @Override
    public void putWithWriter(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.putInternal(element, false, true);
    }

    private void putInternal(Element element, boolean doNotNotifyCacheReplicators, boolean useCacheWriter) {
        if (useCacheWriter) {
            this.initialiseCacheWriterManager(true);
        }
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            if (doNotNotifyCacheReplicators) {
                LOG.debug("Element from replicated put is null. This happens because the element is a SoftReference and it has been collected. Increase heap memory on the JVM or set -Xms to be the same as -Xmx to avoid this problem.");
            }
            return;
        }
        if (element.getObjectKey() == null) {
            return;
        }
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        if (useCacheWriter) {
            boolean elementExists = false;
            boolean notifyListeners = true;
            try {
                elementExists = !this.compoundStore.putWithWriter(element, this.cacheWriterManager);
            }
            catch (StoreUpdateException e) {
                elementExists = e.isUpdate();
                notifyListeners = this.configuration.getCacheWriterConfiguration().getNotifyListenersOnException();
                RuntimeException cause = e.getCause();
                if (cause instanceof CacheWriterManagerException) {
                    throw ((CacheWriterManagerException)cause).getCause();
                }
                throw cause;
            }
            finally {
                if (elementExists) {
                    element.updateUpdateStatistics();
                }
                if (notifyListeners) {
                    this.notifyPutInternalListeners(element, doNotNotifyCacheReplicators, elementExists);
                }
            }
        } else {
            boolean elementExists;
            boolean bl = elementExists = !this.compoundStore.put(element);
            if (elementExists) {
                element.updateUpdateStatistics();
            }
            this.notifyPutInternalListeners(element, doNotNotifyCacheReplicators, elementExists);
        }
    }

    private void notifyPutInternalListeners(Element element, boolean doNotNotifyCacheReplicators, boolean elementExists) {
        if (elementExists) {
            this.registeredEventListeners.notifyElementUpdated(element, doNotNotifyCacheReplicators);
        } else {
            this.registeredEventListeners.notifyElementPut(element, doNotNotifyCacheReplicators);
        }
    }

    private void backOffIfDiskSpoolFull() {
        if (this.compoundStore.bufferFull()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void applyDefaultsToElementWithoutLifespanSet(Element element) {
        if (!element.isLifespanSet()) {
            element.setLifespanDefaults(TimeUtil.convertTimeToInt(this.configuration.getTimeToIdleSeconds()), TimeUtil.convertTimeToInt(this.configuration.getTimeToLiveSeconds()), this.configuration.isEternal());
        }
    }

    @Override
    public final void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null || element.getObjectKey() == null) {
            return;
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.compoundStore.put(element);
    }

    @Override
    public final Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    @Override
    public final Element get(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return null;
        }
        if (this.isStatisticsEnabled()) {
            long start = System.currentTimeMillis();
            Element element = this.searchInStoreWithStats(key);
            long end = System.currentTimeMillis();
            this.liveCacheStatisticsData.addGetTimeMillis(end - start);
            return element;
        }
        return this.searchInStoreWithoutStats(key, false, true);
    }

    @Override
    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        Element element = this.get(key);
        if (element != null) {
            return element;
        }
        if (this.registeredCacheLoaders.size() == 0 && loader == null) {
            return null;
        }
        try {
            element = this.getQuiet(key);
            if (element != null) {
                return element;
            }
            Future future = this.asynchronousLoad(key, loader, loaderArgument);
            long cacheLoaderTimeoutMillis = this.configuration.getCacheLoaderTimeoutMillis();
            if (cacheLoaderTimeoutMillis > 0L) {
                future.get(cacheLoaderTimeoutMillis, TimeUnit.MILLISECONDS);
            } else {
                future.get();
            }
        }
        catch (TimeoutException e) {
            throw new LoaderTimeoutException("Timeout on load for key " + key, e);
        }
        catch (Exception e) {
            throw new CacheException("Exception on load for key " + key, e);
        }
        return this.getQuiet(key);
    }

    @Override
    public void load(Object key) throws CacheException {
        if (this.registeredCacheLoaders.size() == 0) {
            LOG.debug("The CacheLoader is null. Returning.");
            return;
        }
        boolean existsOnCall = this.isKeyInCache(key);
        if (existsOnCall) {
            LOG.debug("The key {} exists in the cache. Returning.", key);
            return;
        }
        this.asynchronousLoad(key, null, null);
    }

    @Override
    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        if (keys == null) {
            return new HashMap(0);
        }
        HashMap map = new HashMap(keys.size());
        ArrayList missingKeys = new ArrayList(keys.size());
        if (this.registeredCacheLoaders.size() > 0) {
            Object key = null;
            try {
                map = new HashMap(keys.size());
                for (Object key1 : keys) {
                    key = key1;
                    Element element = this.get(key);
                    if (element != null) {
                        map.put(key, element.getObjectValue());
                        continue;
                    }
                    if (this.isKeyInCache(key)) {
                        map.put(key, null);
                        continue;
                    }
                    missingKeys.add(key);
                }
                Future future = this.asynchronousLoadAll(missingKeys, loaderArgument);
                long cacheLoaderTimeoutMillis = this.configuration.getCacheLoaderTimeoutMillis();
                if (cacheLoaderTimeoutMillis > 0L) {
                    try {
                        future.get(cacheLoaderTimeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException e) {
                        throw new LoaderTimeoutException("Timeout on load for key " + key, e);
                    }
                } else {
                    future.get();
                }
                for (Object missingKey : missingKeys) {
                    key = missingKey;
                    Element element = this.get(key);
                    if (element != null) {
                        map.put(key, element.getObjectValue());
                        continue;
                    }
                    map.put(key, null);
                }
            }
            catch (InterruptedException e) {
                throw new CacheException(e.getMessage() + " for key " + key, e);
            }
            catch (ExecutionException e) {
                throw new CacheException(e.getMessage() + " for key " + key, e);
            }
        } else {
            for (Object key : keys) {
                Element element = this.get(key);
                if (element != null) {
                    map.put(key, element.getObjectValue());
                    continue;
                }
                map.put(key, null);
            }
        }
        return map;
    }

    @Override
    public void loadAll(Collection keys, Object argument) throws CacheException {
        if (this.registeredCacheLoaders.size() == 0) {
            LOG.debug("The CacheLoader is null. Returning.");
            return;
        }
        if (keys == null) {
            return;
        }
        this.asynchronousLoadAll(keys, argument);
    }

    @Override
    public final Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)key);
    }

    @Override
    public final Element getQuiet(Object key) throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.searchInStoreWithoutStats(key, true, false);
    }

    @Override
    public final List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.compoundStore.getKeys();
    }

    @Override
    public final List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List allKeyList = this.getKeys();
        ArrayList nonExpiredKeys = new ArrayList(allKeyList.size());
        for (Object key : allKeyList) {
            Element element = this.getQuiet(key);
            if (element == null) continue;
            nonExpiredKeys.add(key);
        }
        nonExpiredKeys.trimToSize();
        return nonExpiredKeys;
    }

    @Override
    public final List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        return this.getKeys();
    }

    private Element searchInStoreWithStats(Object key) {
        Element element;
        boolean hasOnDisk;
        boolean wasOnDisk = false;
        boolean wasOffHeap = false;
        boolean hasOffHeap = this.getCacheConfiguration().isOverflowToOffHeap();
        boolean isTCClustered = this.getCacheConfiguration().isTerracottaClustered();
        boolean bl = hasOnDisk = isTCClustered || this.getCacheConfiguration().isOverflowToDisk();
        if (!this.compoundStore.containsKeyInMemory(key)) {
            this.liveCacheStatisticsData.cacheMissInMemory();
            if (hasOffHeap) {
                wasOffHeap = this.compoundStore.containsKeyOffHeap(key);
            }
            if (!wasOffHeap) {
                if (hasOffHeap) {
                    this.liveCacheStatisticsData.cacheMissOffHeap();
                }
                wasOnDisk = this.compoundStore.containsKeyOnDisk(key);
                if (hasOnDisk && !wasOnDisk) {
                    this.liveCacheStatisticsData.cacheMissOnDisk();
                }
            }
        }
        if ((element = this.compoundStore.get(key)) != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.configuration.getName() + " cache hit, but element expired");
                }
                this.liveCacheStatisticsData.cacheMissExpired();
                this.tryRemoveImmediately(key, true);
                element = null;
            } else {
                element.updateAccessStatistics();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(this.getName() + "Cache: " + this.getName() + " store hit for " + key);
                }
                if (wasOffHeap) {
                    this.liveCacheStatisticsData.cacheHitOffHeap();
                } else if (wasOnDisk) {
                    this.liveCacheStatisticsData.cacheHitOnDisk();
                } else {
                    this.liveCacheStatisticsData.cacheHitInMemory();
                }
            }
        } else {
            this.liveCacheStatisticsData.cacheMissNotFound();
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.configuration.getName() + " cache - Miss");
            }
        }
        return element;
    }

    private Element searchInStoreWithoutStats(Object key, boolean quiet, boolean notifyListeners) {
        Element element = this.compoundStore.getQuiet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                this.tryRemoveImmediately(key, notifyListeners);
                element = null;
            } else if (!quiet && !this.skipUpdateAccessStatistics(element)) {
                element.updateAccessStatistics();
            }
        }
        return element;
    }

    private void tryRemoveImmediately(Object key, boolean notifyListeners) {
        boolean writeLocked;
        Sync syncForKey;
        block6: {
            syncForKey = ((CacheLockProvider)this.getInternalContext()).getSyncForKey(key);
            writeLocked = false;
            try {
                writeLocked = syncForKey.tryLock(LockType.WRITE, 0L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Error e) {
                if (e.getClass().getName().equals("com.tc.exception.TCLockUpgradeNotSupportedError")) break block6;
                throw e;
            }
        }
        if (writeLocked) {
            this.removeInternal(key, true, notifyListeners, false, false);
            syncForKey.unlock(LockType.WRITE);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(this.configuration.getName() + " cache: element " + key + " expired, but couldn't be inline evicted");
        }
    }

    private boolean skipUpdateAccessStatistics(Element element) {
        return this.configuration.isFrozen() && element.isEternal() && this.configuration.getMaxElementsInMemory() == 0 && (!this.configuration.isOverflowToDisk() || this.configuration.getMaxElementsOnDisk() == 0);
    }

    @Override
    public final boolean remove(Serializable key) throws IllegalStateException {
        return this.remove((Object)key);
    }

    @Override
    public final boolean remove(Object key) throws IllegalStateException {
        return this.remove(key, false);
    }

    @Override
    public final boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove((Object)key, doNotNotifyCacheReplicators);
    }

    @Override
    public final boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.removeInternal(key, false, true, doNotNotifyCacheReplicators, false);
    }

    @Override
    public final boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.removeInternal(key, false, false, false, false);
    }

    @Override
    public final boolean removeQuiet(Object key) throws IllegalStateException {
        return this.removeInternal(key, false, false, false, false);
    }

    @Override
    public boolean removeWithWriter(Object key) throws IllegalStateException {
        return this.removeInternal(key, false, true, false, true);
    }

    private boolean removeInternal(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators, boolean useCacheWriter) throws IllegalStateException {
        if (useCacheWriter) {
            this.initialiseCacheWriterManager(true);
        }
        this.checkStatus();
        Element elementFromStore = null;
        if (useCacheWriter) {
            try {
                elementFromStore = this.compoundStore.removeWithWriter(key, this.cacheWriterManager);
            }
            catch (CacheWriterManagerException e) {
                if (this.configuration.getCacheWriterConfiguration().getNotifyListenersOnException()) {
                    this.notifyRemoveInternalListeners(key, expiry, notifyListeners, doNotNotifyCacheReplicators, elementFromStore);
                }
                throw e.getCause();
            }
        } else {
            elementFromStore = this.compoundStore.remove(key);
        }
        return this.notifyRemoveInternalListeners(key, expiry, notifyListeners, doNotNotifyCacheReplicators, elementFromStore);
    }

    private boolean notifyRemoveInternalListeners(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators, Element elementFromStore) {
        boolean removed = false;
        boolean removeNotified = false;
        if (elementFromStore != null) {
            if (expiry) {
                this.registeredEventListeners.notifyElementExpiry(elementFromStore, doNotNotifyCacheReplicators);
            } else if (notifyListeners) {
                removeNotified = true;
                this.registeredEventListeners.notifyElementRemoved(elementFromStore, doNotNotifyCacheReplicators);
            }
            removed = true;
        }
        if (notifyListeners && !expiry && !removeNotified) {
            Element syntheticElement = new Element(key, null);
            this.registeredEventListeners.notifyElementRemoved(syntheticElement, doNotNotifyCacheReplicators);
        }
        return removed;
    }

    @Override
    public void removeAll() throws IllegalStateException, CacheException {
        this.removeAll(false);
    }

    @Override
    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.checkStatus();
        this.compoundStore.removeAll();
        this.registeredEventListeners.notifyRemoveAll(doNotNotifyCacheReplicators);
    }

    @Override
    public synchronized void dispose() throws IllegalStateException {
        if (this.checkStatusAlreadyDisposed()) {
            return;
        }
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.disposeRegisteredCacheExtensions();
        this.disposeRegisteredCacheLoaders();
        this.disposeRegisteredCacheWriter();
        this.registeredEventListeners.dispose();
        if (this.cacheWriterManager != null) {
            this.cacheWriterManager.dispose();
        }
        if (this.compoundStore != null) {
            this.compoundStore.removeStoreListener(this);
            this.compoundStore.dispose();
        }
        this.cacheStatus.changeState(Status.STATUS_SHUTDOWN);
    }

    private void initialiseRegisteredCacheExtensions() {
        for (CacheExtension cacheExtension : this.registeredCacheExtensions) {
            cacheExtension.init();
        }
    }

    private void disposeRegisteredCacheExtensions() {
        for (CacheExtension cacheExtension : this.registeredCacheExtensions) {
            cacheExtension.dispose();
        }
    }

    private void initialiseRegisteredCacheLoaders() {
        for (CacheLoader cacheLoader : this.registeredCacheLoaders) {
            cacheLoader.init();
        }
    }

    private void disposeRegisteredCacheLoaders() {
        for (CacheLoader cacheLoader : this.registeredCacheLoaders) {
            cacheLoader.dispose();
        }
    }

    private void initialiseRegisteredCacheWriter() {
        CacheWriter writer = this.registeredCacheWriter;
        if (writer != null) {
            writer.init();
        }
    }

    private void disposeRegisteredCacheWriter() {
        CacheWriter writer = this.registeredCacheWriter;
        if (writer != null) {
            writer.dispose();
        }
    }

    @Override
    public CacheConfiguration getCacheConfiguration() {
        return this.configuration;
    }

    @Override
    public final synchronized void flush() throws IllegalStateException, CacheException {
        this.checkStatus();
        try {
            this.compoundStore.flush();
        }
        catch (IOException e) {
            throw new CacheException("Unable to flush cache: " + this.configuration.getName() + ". Initial cause was " + e.getMessage(), e);
        }
    }

    @Override
    public final int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        if (this.compoundStore.isCacheCoherent()) {
            return this.compoundStore.getTerracottaClusteredSize();
        }
        return this.compoundStore.getSize();
    }

    @Override
    public int getSizeBasedOnAccuracy(int statisticsAccuracy) throws IllegalStateException, CacheException {
        if (statisticsAccuracy == 1) {
            return this.getSize();
        }
        if (statisticsAccuracy == 2) {
            return this.getKeysWithExpiryCheck().size();
        }
        if (statisticsAccuracy == 0) {
            return this.getKeysNoDuplicateCheck().size();
        }
        throw new IllegalArgumentException("Unknown statistics accuracy: " + statisticsAccuracy);
    }

    @Override
    public final long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.compoundStore.getInMemorySizeInBytes();
    }

    @Override
    public final long calculateOffHeapSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.compoundStore.getOffHeapSizeInBytes();
    }

    @Override
    public final long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.compoundStore.getInMemorySize();
    }

    @Override
    public long getOffHeapStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.compoundStore.getOffHeapSize();
    }

    @Override
    public final int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.isTerracottaClustered()) {
            return this.compoundStore.getTerracottaClusteredSize();
        }
        return this.compoundStore.getOnDiskSize();
    }

    @Override
    public final Status getStatus() {
        return this.cacheStatus.getStatus();
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.cacheStatus.isAlive()) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is not alive.");
        }
    }

    private boolean checkStatusAlreadyDisposed() throws IllegalStateException {
        return this.cacheStatus.isShutdown();
    }

    @Override
    public final String getName() {
        return this.configuration.getName();
    }

    @Override
    public final void setName(String name) throws IllegalArgumentException {
        if (!this.cacheStatus.isUninitialized()) {
            throw new IllegalStateException("Only uninitialised caches can have their names set.");
        }
        this.configuration.setName(name);
    }

    @Override
    public String toString() {
        StringBuilder dump = new StringBuilder();
        dump.append("[").append(" name = ").append(this.configuration.getName()).append(" status = ").append(this.cacheStatus.getStatus()).append(" eternal = ").append(this.configuration.isEternal()).append(" overflowToDisk = ").append(this.configuration.isOverflowToDisk()).append(" maxElementsInMemory = ").append(this.configuration.getMaxElementsInMemory()).append(" maxElementsOnDisk = ").append(this.configuration.getMaxElementsOnDisk()).append(" memoryStoreEvictionPolicy = ").append(this.configuration.getMemoryStoreEvictionPolicy()).append(" timeToLiveSeconds = ").append(this.configuration.getTimeToLiveSeconds()).append(" timeToIdleSeconds = ").append(this.configuration.getTimeToIdleSeconds()).append(" diskPersistent = ").append(this.configuration.isDiskPersistent()).append(" diskExpiryThreadIntervalSeconds = ").append(this.configuration.getDiskExpiryThreadIntervalSeconds()).append(this.registeredEventListeners).append(" hitCount = ").append(this.getLiveCacheStatisticsNoCheck().getCacheHitCount()).append(" memoryStoreHitCount = ").append(this.getLiveCacheStatisticsNoCheck().getInMemoryHitCount()).append(" diskStoreHitCount = ").append(this.getLiveCacheStatisticsNoCheck().getOnDiskHitCount()).append(" missCountNotFound = ").append(this.getLiveCacheStatisticsNoCheck().getCacheMissCount()).append(" missCountExpired = ").append(this.getLiveCacheStatisticsNoCheck().getCacheMissCountExpired()).append(" overflowToOffHeap = ").append(this.configuration.isOverflowToOffHeap()).append(" maxMemoryOffHeap = ").append(this.configuration.getMaxMemoryOffHeap()).append(" ]");
        return dump.toString();
    }

    @Override
    public final boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        return element.isExpired(this.configuration);
    }

    @Override
    public final Cache clone() throws CloneNotSupportedException {
        if (this.compoundStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        Cache copy = (Cache)super.clone();
        copy.liveCacheStatisticsData = new LiveCacheStatisticsWrapper(copy);
        copy.sampledCacheStatistics = new SampledCacheStatisticsWrapper();
        copy.configuration = this.configuration.clone();
        copy.guid = this.createGuid();
        copy.cacheStatus = new CacheStatus();
        copy.cacheStatus.changeState(Status.STATUS_UNINITIALISED);
        copy.elementValueComparator = copy.configuration.getElementValueComparatorConfiguration().getElementComparatorInstance();
        copy.propertyChangeSupport = new PropertyChangeSupport(copy);
        copy.nonstopActiveDelegateHolder = new NonstopActiveDelegateHolderImpl(copy);
        for (PropertyChangeListener propertyChangeListener : this.propertyChangeSupport.getPropertyChangeListeners()) {
            copy.addPropertyChangeListener(propertyChangeListener);
        }
        RegisteredEventListeners registeredEventListenersFromCopy = copy.getCacheEventNotificationService();
        if (registeredEventListenersFromCopy == null || registeredEventListenersFromCopy.getCacheEventListeners().size() == 0) {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
        } else {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
            Set<CacheEventListener> cacheEventListeners = this.registeredEventListeners.getCacheEventListeners();
            Iterator<CacheEventListener> i$ = cacheEventListeners.iterator();
            while (i$.hasNext()) {
                CacheEventListener cacheEventListener1;
                CacheEventListener cacheEventListener = cacheEventListener1 = i$.next();
                CacheEventListener cacheEventListenerClone = (CacheEventListener)cacheEventListener.clone();
                copy.registeredEventListeners.registerListener(cacheEventListenerClone);
            }
        }
        copy.registeredCacheExtensions = new CopyOnWriteArrayList<CacheExtension>();
        for (CacheExtension registeredCacheExtension : this.registeredCacheExtensions) {
            copy.registerCacheExtension(registeredCacheExtension.clone(copy));
        }
        copy.registeredCacheLoaders = new CopyOnWriteArrayList<CacheLoader>();
        for (CacheLoader registeredCacheLoader : this.registeredCacheLoaders) {
            copy.registerCacheLoader(registeredCacheLoader.clone(copy));
        }
        if (this.registeredCacheWriter != null) {
            copy.registerCacheWriter(this.registeredCacheWriter.clone(copy));
        }
        if (this.bootstrapCacheLoader != null) {
            BootstrapCacheLoader bootstrapCacheLoaderClone = (BootstrapCacheLoader)this.bootstrapCacheLoader.clone();
            copy.setBootstrapCacheLoader(bootstrapCacheLoaderClone);
        }
        return copy;
    }

    final Store getStore() throws IllegalStateException {
        this.checkStatus();
        return this.compoundStore;
    }

    public final Object getStoreMBean() {
        return this.getStore().getMBean();
    }

    @Override
    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    @Override
    public final boolean isElementInMemory(Serializable key) {
        return this.isElementInMemory((Object)key);
    }

    @Override
    public final boolean isElementInMemory(Object key) {
        return this.compoundStore.containsKeyInMemory(key);
    }

    public final boolean isElementOffHeap(Object key) {
        return this.compoundStore.containsKeyOffHeap(key);
    }

    @Override
    public final boolean isElementOnDisk(Serializable key) {
        return this.isElementOnDisk((Object)key);
    }

    @Override
    public final boolean isElementOnDisk(Object key) {
        return this.compoundStore.containsKeyOnDisk(key);
    }

    @Override
    public final String getGuid() {
        return this.guid;
    }

    @Override
    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void clearStatistics() throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.clearStatistics();
        this.sampledCacheStatistics.clearStatistics();
        this.registeredEventListeners.clearCounters();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.getLiveCacheStatistics().getStatisticsAccuracy();
    }

    @Override
    public void setStatisticsAccuracy(int statisticsAccuracy) {
        int oldValue = this.getStatisticsAccuracy();
        if (statisticsAccuracy != oldValue) {
            this.liveCacheStatisticsData.setStatisticsAccuracy(statisticsAccuracy);
            this.firePropertyChange("StatisticsAccuracy", oldValue, statisticsAccuracy);
        }
    }

    @Override
    public void evictExpiredElements() {
        this.compoundStore.expireElements();
    }

    @Override
    public boolean isKeyInCache(Object key) {
        if (key == null) {
            return false;
        }
        return this.isElementInMemory(key) || this.isElementOffHeap(key) || this.isElementOnDisk(key);
    }

    @Override
    public boolean isValueInCache(Object value) {
        for (Object key : this.getKeys()) {
            Serializable elementValue;
            Element element = this.get(key);
            if (element == null || !((elementValue = element.getValue()) == null ? value == null : elementValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Statistics getStatistics() throws IllegalStateException {
        int size = this.getSizeBasedOnAccuracy(this.getLiveCacheStatistics().getStatisticsAccuracy());
        return new Statistics(this, this.getLiveCacheStatistics().getStatisticsAccuracy(), this.getLiveCacheStatistics().getCacheHitCount(), this.getLiveCacheStatistics().getOnDiskHitCount(), this.getLiveCacheStatistics().getOffHeapHitCount(), this.getLiveCacheStatistics().getInMemoryHitCount(), this.getLiveCacheStatistics().getCacheMissCount(), this.getLiveCacheStatistics().getOnDiskMissCount(), this.getLiveCacheStatistics().getOffHeapMissCount(), this.getLiveCacheStatistics().getInMemoryMissCount(), size, this.getAverageGetTime(), this.getLiveCacheStatistics().getEvictedCount(), this.getMemoryStoreSize(), this.getOffHeapStoreSize(), this.getDiskStoreSize(), this.getSearchesPerSecond(), this.getAverageSearchTime(), this.getLiveCacheStatistics().getWriterQueueLength());
    }

    @Override
    public long getAverageSearchTime() {
        return this.sampledCacheStatistics.getAverageSearchTime();
    }

    @Override
    public long getSearchesPerSecond() {
        return this.sampledCacheStatistics.getSearchesPerSecond();
    }

    @Override
    public void setCacheManager(CacheManager cacheManager) {
        CacheManager oldValue = this.getCacheManager();
        this.cacheManager = cacheManager;
        this.firePropertyChange("CacheManager", oldValue, cacheManager);
    }

    @Override
    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.bootstrapCacheLoader;
    }

    @Override
    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        if (!this.cacheStatus.isUninitialized()) {
            throw new CacheException("A bootstrap cache loader can only be set before the cache is initialized. " + this.configuration.getName());
        }
        BootstrapCacheLoader oldValue = this.getBootstrapCacheLoader();
        this.bootstrapCacheLoader = bootstrapCacheLoader;
        this.firePropertyChange("BootstrapCacheLoader", oldValue, bootstrapCacheLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDiskStorePath(String diskStorePath) throws CacheException {
        if (!this.cacheStatus.isUninitialized()) {
            throw new CacheException("A DiskStore path can only be set before the cache is initialized. " + this.configuration.getName());
        }
        String oldValue = this.diskStorePath;
        Cache cache = this;
        synchronized (cache) {
            this.diskStorePath = diskStorePath;
        }
        this.firePropertyChange("DiskStorePath", oldValue, diskStorePath);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ehcache)) {
            return false;
        }
        Ehcache other = (Ehcache)object;
        return this.guid.equals(other.getGuid());
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    private String createGuid() {
        StringBuilder buffer = new StringBuilder().append(localhost).append("-").append(UUID.randomUUID());
        return buffer.toString();
    }

    @Override
    public void registerCacheExtension(CacheExtension cacheExtension) {
        this.registeredCacheExtensions.add(cacheExtension);
    }

    @Override
    public List<CacheExtension> getRegisteredCacheExtensions() {
        return this.registeredCacheExtensions;
    }

    @Override
    public void unregisterCacheExtension(CacheExtension cacheExtension) {
        cacheExtension.dispose();
        this.registeredCacheExtensions.remove(cacheExtension);
    }

    @Override
    public float getAverageGetTime() {
        return this.getLiveCacheStatistics().getAverageGetTimeMillis();
    }

    @Override
    public void setCacheExceptionHandler(CacheExceptionHandler cacheExceptionHandler) {
        CacheExceptionHandler oldValue = this.getCacheExceptionHandler();
        this.cacheExceptionHandler = cacheExceptionHandler;
        this.firePropertyChange("CacheExceptionHandler", oldValue, cacheExceptionHandler);
    }

    @Override
    public CacheExceptionHandler getCacheExceptionHandler() {
        return this.cacheExceptionHandler;
    }

    @Override
    public void registerCacheLoader(CacheLoader cacheLoader) {
        this.registeredCacheLoaders.add(cacheLoader);
    }

    @Override
    public void unregisterCacheLoader(CacheLoader cacheLoader) {
        this.registeredCacheLoaders.remove(cacheLoader);
    }

    @Override
    public List<CacheLoader> getRegisteredCacheLoaders() {
        return this.registeredCacheLoaders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerCacheWriter(CacheWriter cacheWriter) {
        Cache cache = this;
        synchronized (cache) {
            this.registeredCacheWriter = cacheWriter;
            if (this.cacheStatus.isAlive()) {
                this.initialiseRegisteredCacheWriter();
            }
        }
        this.initialiseCacheWriterManager(false);
    }

    @Override
    public void unregisterCacheWriter() {
        if (this.cacheWriterManagerInitFlag.get()) {
            throw new CacheException("Cache: " + this.configuration.getName() + " has its cache writer being unregistered " + "after it was already initialised.");
        }
        this.registeredCacheWriter = null;
    }

    @Override
    public CacheWriter getRegisteredCacheWriter() {
        return this.registeredCacheWriter;
    }

    Future asynchronousLoad(final Object key, final CacheLoader specificLoader, final Object argument) {
        return this.getExecutorService().submit(new Runnable(){

            public void run() throws CacheException {
                try {
                    boolean existsOnRun = Cache.this.isKeyInCache(key);
                    if (!existsOnRun) {
                        Object value;
                        if (specificLoader == null) {
                            if (Cache.this.registeredCacheLoaders.size() == 0) {
                                return;
                            }
                            value = Cache.this.loadWithRegisteredLoaders(argument, key);
                        } else {
                            value = argument == null ? specificLoader.load(key) : specificLoader.load(key, argument);
                        }
                        if (value != null) {
                            Cache.this.put(new Element(key, value), false);
                        }
                    }
                }
                catch (Throwable e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Problem during load. Load will not be completed. Cause was " + e.getCause(), e);
                    }
                    throw new CacheException("Problem during load. Load will not be completed. Cause was " + e.getCause(), e);
                }
            }
        });
    }

    private Object loadWithRegisteredLoaders(Object argument, Object key) throws CacheException {
        Object value = null;
        if (argument == null) {
            CacheLoader registeredCacheLoader;
            Iterator<CacheLoader> i$ = this.registeredCacheLoaders.iterator();
            while (i$.hasNext() && (value = (registeredCacheLoader = i$.next()).load(key)) == null) {
            }
        } else {
            CacheLoader registeredCacheLoader;
            Iterator<CacheLoader> i$ = this.registeredCacheLoaders.iterator();
            while (i$.hasNext() && (value = (registeredCacheLoader = i$.next()).load(key, argument)) == null) {
            }
        }
        return value;
    }

    Future asynchronousLoadAll(final Collection keys, final Object argument) {
        return this.getExecutorService().submit(new Runnable(){

            public void run() {
                block4: {
                    try {
                        HashSet<Object> nonLoadedKeys = new HashSet<Object>();
                        for (Object key : keys) {
                            if (Cache.this.isKeyInCache(key)) continue;
                            nonLoadedKeys.add(key);
                        }
                        Map map = Cache.this.loadWithRegisteredLoaders(argument, nonLoadedKeys);
                        for (Object key : map.keySet()) {
                            Cache.this.put(new Element(key, map.get(key)));
                        }
                    }
                    catch (Throwable e) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error("Problem during load. Load will not be completed. Cause was " + e.getCause(), e);
                    }
                }
            }
        });
    }

    Map loadWithRegisteredLoaders(Object argument, Set<Object> nonLoadedKeys) {
        HashMap result = new HashMap();
        for (CacheLoader registeredCacheLoader : this.registeredCacheLoaders) {
            if (nonLoadedKeys.isEmpty()) break;
            Map resultForThisCacheLoader = null;
            resultForThisCacheLoader = argument == null ? registeredCacheLoader.loadAll(nonLoadedKeys) : registeredCacheLoader.loadAll(nonLoadedKeys, argument);
            if (resultForThisCacheLoader == null) continue;
            nonLoadedKeys.removeAll(resultForThisCacheLoader.keySet());
            result.putAll(resultForThisCacheLoader);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService() {
        if (this.executorService == null) {
            Cache cache = this;
            synchronized (cache) {
                this.executorService = VmUtils.isInGoogleAppEngine() ? new AbstractExecutorService(){

                    @Override
                    public void execute(Runnable command) {
                        command.run();
                    }

                    @Override
                    public List<Runnable> shutdownNow() {
                        return Collections.emptyList();
                    }

                    @Override
                    public void shutdown() {
                    }

                    @Override
                    public boolean isTerminated() {
                        return this.isShutdown();
                    }

                    @Override
                    public boolean isShutdown() {
                        return false;
                    }

                    @Override
                    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
                        return true;
                    }
                } : new ThreadPoolExecutor(1, EXECUTOR_MAXIMUM_POOL_SIZE, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("Cache Executor Service"));
            }
        }
        return this.executorService;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisabled(boolean disabled) {
        if (this.allowDisable) {
            boolean oldValue = this.isDisabled();
            if (oldValue != disabled) {
                Cache cache = this;
                synchronized (cache) {
                    this.disabled = disabled;
                }
                this.firePropertyChange("Disabled", oldValue, disabled);
            }
        } else {
            throw new CacheException("Dynamic cache features are disabled");
        }
    }

    public Policy getMemoryStoreEvictionPolicy() {
        return this.compoundStore.getInMemoryEvictionPolicy();
    }

    public void setMemoryStoreEvictionPolicy(Policy policy) {
        Policy oldValue = this.getMemoryStoreEvictionPolicy();
        this.compoundStore.setInMemoryEvictionPolicy(policy);
        this.firePropertyChange("MemoryStoreEvictionPolicy", oldValue, policy);
    }

    @Override
    public LiveCacheStatistics getLiveCacheStatistics() throws IllegalStateException {
        this.checkStatus();
        return this.liveCacheStatisticsData;
    }

    private LiveCacheStatistics getLiveCacheStatisticsNoCheck() {
        return this.liveCacheStatisticsData;
    }

    @Override
    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.registerCacheUsageListener(cacheUsageListener);
    }

    @Override
    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.checkStatus();
        this.liveCacheStatisticsData.removeCacheUsageListener(cacheUsageListener);
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.getLiveCacheStatistics().isStatisticsEnabled();
    }

    @Override
    public void setStatisticsEnabled(boolean enableStatistics) {
        boolean oldValue = this.isStatisticsEnabled();
        if (oldValue != enableStatistics) {
            this.liveCacheStatisticsData.setStatisticsEnabled(enableStatistics);
            if (!enableStatistics) {
                this.setSampledStatisticsEnabled(false);
            }
            this.firePropertyChange("StatisticsEnabled", oldValue, enableStatistics);
        }
    }

    @Override
    public SampledCacheStatistics getSampledCacheStatistics() {
        return this.sampledCacheStatistics;
    }

    @Override
    public void setSampledStatisticsEnabled(boolean enableStatistics) {
        if (this.cacheManager == null) {
            throw new IllegalStateException("You must add the cache to a CacheManager before enabling/disabling sampled statistics.");
        }
        boolean oldValue = this.isSampledStatisticsEnabled();
        if (oldValue != enableStatistics) {
            if (enableStatistics) {
                this.setStatisticsEnabled(true);
                this.sampledCacheStatistics.enableSampledStatistics(this.cacheManager.getTimer());
            } else {
                this.sampledCacheStatistics.disableSampledStatistics();
            }
            this.firePropertyChange("SampledStatisticsEnabled", oldValue, enableStatistics);
        }
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.sampledCacheStatistics.isSampledStatisticsEnabled();
    }

    @Override
    public Object getInternalContext() {
        return this.compoundStore.getInternalContext();
    }

    @Override
    public void disableDynamicFeatures() {
        this.configuration.freezeConfiguration();
        this.allowDisable = false;
    }

    @Override
    @Deprecated
    public boolean isClusterCoherent() {
        return !this.isClusterBulkLoadEnabled();
    }

    @Override
    @Deprecated
    public boolean isNodeCoherent() {
        return !this.isNodeBulkLoadEnabled();
    }

    @Override
    @Deprecated
    public void setNodeCoherent(boolean coherent) {
        this.setNodeBulkLoadEnabled(!coherent);
    }

    @Override
    @Deprecated
    public void waitUntilClusterCoherent() {
        this.waitUntilClusterBulkLoadComplete();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null && this.propertyChangeSupport != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport pcs;
        Cache cache = this;
        synchronized (cache) {
            pcs = this.propertyChangeSupport;
        }
        if (pcs != null && (oldValue != null || newValue != null)) {
            pcs.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        this.checkStatus();
        if (element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (this.disabled) {
            return null;
        }
        this.getQuiet(element.getObjectKey());
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        Element result = this.compoundStore.putIfAbsent(element);
        if (result == null) {
            this.notifyPutInternalListeners(element, false, false);
        }
        return result;
    }

    @Override
    public boolean removeElement(Element element) throws NullPointerException {
        this.checkStatus();
        if (element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (this.disabled) {
            return false;
        }
        this.getQuiet(element.getObjectKey());
        Element result = this.compoundStore.removeElement(element, this.elementValueComparator);
        this.notifyRemoveInternalListeners(element.getObjectKey(), false, true, false, result);
        return result != null;
    }

    @Override
    public boolean replace(Element old, Element element) throws NullPointerException, IllegalArgumentException {
        this.checkStatus();
        if (old.getObjectKey() == null || element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (!old.getObjectKey().equals(element.getObjectKey())) {
            throw new IllegalArgumentException("The keys for the element arguments to replace must be equal");
        }
        if (this.disabled) {
            return false;
        }
        this.getQuiet(old.getObjectKey());
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        boolean result = this.compoundStore.replace(old, element, this.elementValueComparator);
        if (result) {
            element.updateUpdateStatistics();
            this.notifyPutInternalListeners(element, false, true);
        }
        return result;
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        this.checkStatus();
        if (element.getObjectKey() == null) {
            throw new NullPointerException();
        }
        if (this.disabled) {
            return null;
        }
        this.getQuiet(element.getObjectKey());
        element.resetAccessStatistics();
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        Element result = this.compoundStore.replace(element);
        if (result != null) {
            element.updateUpdateStatistics();
            this.notifyPutInternalListeners(element, false, true);
        }
        return result;
    }

    @Override
    public void clusterCoherent(boolean clusterCoherent) {
        this.firePropertyChange("ClusterCoherent", !clusterCoherent, clusterCoherent);
    }

    @Override
    public void nodeCoherent(boolean nodeCoherent) {
        this.firePropertyChange("NodeCoherent", !nodeCoherent, nodeCoherent);
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        Attribute searchAttribute = this.compoundStore.getSearchAttribute(attributeName);
        if (searchAttribute == null) {
            throw new CacheException("No such search attribute [" + attributeName + "] defined for this cache [" + this.getName() + "]");
        }
        return searchAttribute;
    }

    @Override
    public Query createQuery() {
        if (!this.isSearchable()) {
            throw new CacheException("This cache is not configured for search");
        }
        return new CacheQuery(this);
    }

    Results executeQuery(StoreQuery query) throws SearchException {
        if (!query.requestsKeys() && !query.requestsValues() && query.requestedAttributes().isEmpty() && query.getAggregatorInstances().isEmpty()) {
            String msg = "No results specified. Please specify one or more of includeKeys(), includeValues(), includeAggregator() or includeAttribute()";
            throw new SearchException(msg);
        }
        if (this.isStatisticsEnabled()) {
            long start = System.currentTimeMillis();
            Results results = this.compoundStore.executeQuery(query);
            this.sampledCacheStatistics.notifyCacheSearch(System.currentTimeMillis() - start);
            return results;
        }
        return this.compoundStore.executeQuery(query);
    }

    @Override
    public boolean isSearchable() {
        return this.configuration.isSearchable();
    }

    void clusterRejoinStarted() {
        try {
            this.nonstopActiveDelegateHolder.getUnderlyingTerracottaStore().dispose();
        }
        catch (Exception e) {
            LOG.info("Ignoring exception while disposing old store on rejoin - " + e.getMessage());
        }
        this.cacheStatus.clusterRejoinInProgress();
    }

    void clusterRejoinComplete() {
        this.initialise();
        this.cacheStatus.clusterRejoinComplete();
    }

    protected Sync getLockForKey(Object key) {
        return this.lockProvider.getSyncForKey(key);
    }

    private void acquireLockOnKey(Object key, LockType lockType) {
        Sync s = this.getLockForKey(key);
        s.lock(lockType);
    }

    private void releaseLockOnKey(Object key, LockType lockType) {
        Sync s = this.getLockForKey(key);
        s.unlock(lockType);
    }

    @Override
    public void acquireReadLockOnKey(Object key) {
        this.acquireLockOnKey(key, LockType.READ);
    }

    @Override
    public void acquireWriteLockOnKey(Object key) {
        this.acquireLockOnKey(key, LockType.WRITE);
    }

    @Override
    public boolean tryReadLockOnKey(Object key, long timeout) throws InterruptedException {
        Sync s = this.getLockForKey(key);
        return s.tryLock(LockType.READ, timeout);
    }

    @Override
    public boolean tryWriteLockOnKey(Object key, long timeout) throws InterruptedException {
        Sync s = this.getLockForKey(key);
        return s.tryLock(LockType.WRITE, timeout);
    }

    @Override
    public void releaseReadLockOnKey(Object key) {
        this.releaseLockOnKey(key, LockType.READ);
    }

    @Override
    public void releaseWriteLockOnKey(Object key) {
        this.releaseLockOnKey(key, LockType.WRITE);
    }

    @Override
    public boolean isClusterBulkLoadEnabled() throws UnsupportedOperationException, TerracottaNotRunningException {
        return !this.compoundStore.isClusterCoherent();
    }

    @Override
    public boolean isNodeBulkLoadEnabled() throws UnsupportedOperationException, TerracottaNotRunningException {
        return !this.compoundStore.isNodeCoherent();
    }

    @Override
    public void setNodeBulkLoadEnabled(boolean enabledBulkLoad) throws UnsupportedOperationException, TerracottaNotRunningException {
        boolean oldValue = this.isNodeBulkLoadEnabled();
        if (oldValue != enabledBulkLoad) {
            this.compoundStore.setNodeCoherent(!enabledBulkLoad);
            this.nonstopActiveDelegateHolder.nodeBulkLoadChanged(enabledBulkLoad);
        }
    }

    @Override
    public void waitUntilClusterBulkLoadComplete() throws UnsupportedOperationException, TerracottaNotRunningException {
        this.compoundStore.waitUntilClusterCoherent();
    }

    static {
        EXECUTOR_MAXIMUM_POOL_SIZE = Math.min(10, Runtime.getRuntime().availableProcessors());
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.error("Unable to set localhost. This prevents creation of a GUID. Cause was: " + e.getMessage(), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            LOG.debug("InetAddress is being blocked by your runtime environment. e.g. Google App Engine. Ehcache will work as a local cache.");
        }
    }

    private static class NonstopActiveDelegateHolderImpl
    implements NonstopActiveDelegateHolder {
        private final Cache cache;
        private volatile NonstopStoreImpl nonstopStore;
        private volatile TerracottaStore underlyingTerracottaStore;
        private volatile NonstopExecutorService nonstopExecutorService;
        private volatile CacheLockProvider underlyingCacheLockProvider;
        private volatile boolean nodeBulkLoadEnabled;

        public NonstopActiveDelegateHolderImpl(Cache cache) {
            this.cache = cache;
        }

        public void nodeBulkLoadChanged(boolean enabled) {
            this.nodeBulkLoadEnabled = enabled;
        }

        public NonstopStore getNonstopStore() {
            if (this.nonstopStore != null) {
                return this.nonstopStore;
            }
            this.initializeNonstopStore();
            return this.nonstopStore;
        }

        private synchronized void initializeNonstopStore() {
            if (this.nonstopStore == null) {
                if (!this.cache.getCacheConfiguration().isTerracottaClustered()) {
                    throw new AssertionError((Object)"NonstopStore supported for Terracotta clustered caches only");
                }
                if (!this.cache.getCacheConfiguration().getTerracottaConfiguration().isNonstopEnabled()) {
                    throw new AssertionError((Object)"Nonstop is not enabled");
                }
                this.nonstopStore = new NonstopStoreImpl(this, this.cache.getCacheCluster(), this.cache.getCacheConfiguration().getTerracottaConfiguration().getNonstopConfiguration());
            }
        }

        public synchronized void terracottaStoreInitialized(TerracottaStore newTerracottaStore) {
            this.underlyingTerracottaStore = newTerracottaStore;
            if (this.nodeBulkLoadEnabled) {
                LOG.debug("Enabling bulk-load for " + this.cache.getName());
                this.underlyingTerracottaStore.setNodeCoherent(false);
            }
            this.nonstopExecutorService = CacheManagerExecutorServiceFactory.getInstance().getOrCreateNonstopExecutorService(this.cache.getCacheManager());
            Object context = this.underlyingTerracottaStore.getInternalContext();
            if (!(context instanceof CacheLockProvider)) {
                throw new AssertionError((Object)("TerracottaStore.getInternalContext() is not correct - " + (context == null ? "NULL" : context.getClass().getName())));
            }
            this.underlyingCacheLockProvider = (CacheLockProvider)context;
        }

        public TerracottaStore getUnderlyingTerracottaStore() {
            return this.underlyingTerracottaStore;
        }

        public NonstopExecutorService getNonstopExecutorService() {
            return this.nonstopExecutorService;
        }

        public CacheLockProvider getUnderlyingCacheLockProvider() {
            return this.underlyingCacheLockProvider;
        }
    }

    private static class CacheStatus {
        private volatile Status status = Status.STATUS_UNINITIALISED;
        private final AtomicBoolean clusterRejoinInProgress = new AtomicBoolean(false);

        private CacheStatus() {
        }

        private void clusterRejoinComplete() {
            this.clusterRejoinInProgress.set(false);
        }

        private void clusterRejoinInProgress() {
            this.clusterRejoinInProgress.set(true);
        }

        public boolean canInitialize() {
            return this.status == Status.STATUS_UNINITIALISED || this.clusterRejoinInProgress.get();
        }

        public void changeState(Status newState) {
            this.status = newState;
        }

        public Status getStatus() {
            return this.status;
        }

        public boolean isAlive() {
            return this.status == Status.STATUS_ALIVE;
        }

        public boolean isShutdown() {
            return this.status == Status.STATUS_SHUTDOWN;
        }

        public boolean isUninitialized() {
            return this.status == Status.STATUS_UNINITIALISED;
        }
    }
}

