/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.spring;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opennms.core.spring.BeanFactoryReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class ContextRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRegistry.class);
    private static final String BEAN_REF_CONTEXT_RESOURCE = "beanRefContext.xml";
    private final Map<String, ContextReference> contextRegistry = new ConcurrentHashMap<String, ContextReference>();
    private final Object lock = new Object();
    private static final ContextRegistry INSTANCE = new ContextRegistry();

    private ContextRegistry() {
        this.initializeContexts();
    }

    public static ContextRegistry getInstance() {
        return INSTANCE;
    }

    private void initializeContexts() {
        try {
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource[] resources = resolver.getResources("classpath*:beanRefContext.xml");
            if (resources.length == 0) {
                LOG.warn("No {} files found on classpath", (Object)BEAN_REF_CONTEXT_RESOURCE);
                return;
            }
            LOG.debug("Found {} {} files on classpath", (Object)resources.length, (Object)BEAN_REF_CONTEXT_RESOURCE);
            DefaultListableBeanFactory mergedFactory = new DefaultListableBeanFactory();
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)mergedFactory);
            for (Resource resource : resources) {
                LOG.debug("Loading context definitions from: {}", (Object)resource.getURL());
                reader.loadBeanDefinitions(resource);
            }
            this.processContextDefinitions(mergedFactory);
        }
        catch (Exception e) {
            LOG.error("Error initializing contexts", (Throwable)e);
        }
    }

    private void processContextDefinitions(DefaultListableBeanFactory factory) {
        String[] beanNames;
        for (String beanName : beanNames = factory.getBeanDefinitionNames()) {
            try {
                Class beanType = factory.getType(beanName);
                if (beanType == null || !ClassPathXmlApplicationContext.class.isAssignableFrom(beanType)) continue;
                this.contextRegistry.put(beanName, new ContextReference(beanName, factory));
                LOG.debug("Registered context definition: {}", (Object)beanName);
            }
            catch (Exception e) {
                LOG.error("Error processing bean definition: {}", (Object)beanName, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanFactoryReference getBeanFactory(String contextId) {
        Object object = this.lock;
        synchronized (object) {
            ContextReference ref = this.contextRegistry.get(contextId);
            if (ref == null) {
                throw new IllegalArgumentException("No context registered with ID: " + contextId);
            }
            return ref.getBeanFactoryReference();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContext(String contextId, ApplicationContext context) {
        Object object = this.lock;
        synchronized (object) {
            this.contextRegistry.put(contextId, new ContextReference(contextId, context));
            LOG.debug("Programmatically registered context: {}", (Object)contextId);
        }
    }

    public boolean hasContext(String contextId) {
        return this.contextRegistry.containsKey(contextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadContexts() {
        Object object = this.lock;
        synchronized (object) {
            this.contextRegistry.clear();
            this.initializeContexts();
        }
    }

    private class ContextReference {
        private final String contextId;
        private final DefaultListableBeanFactory definitionFactory;
        private ApplicationContext context;
        private int referenceCount = 0;

        ContextReference(String contextId, DefaultListableBeanFactory definitionFactory) {
            this.contextId = contextId;
            this.definitionFactory = definitionFactory;
        }

        ContextReference(String contextId, ApplicationContext context) {
            this.contextId = contextId;
            this.definitionFactory = null;
            this.context = context;
        }

        synchronized BeanFactoryReference getBeanFactoryReference() {
            if (this.context == null && this.definitionFactory != null) {
                this.context = (ApplicationContext)this.definitionFactory.getBean(this.contextId);
                LOG.debug("Lazy loaded context: {}", (Object)this.contextId);
            }
            ++this.referenceCount;
            return new BeanFactoryReference(){
                private boolean released = false;

                @Override
                public BeanFactory getFactory() {
                    if (this.released) {
                        throw new IllegalStateException("BeanFactory reference has already been released");
                    }
                    return ContextReference.this.context;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void release() {
                    if (!this.released) {
                        ContextReference contextReference = ContextReference.this;
                        synchronized (contextReference) {
                            this.released = true;
                            ContextReference.this.referenceCount--;
                            LOG.debug("Released reference to context: {}, remaining references: {}", (Object)ContextReference.this.contextId, (Object)ContextReference.this.referenceCount);
                        }
                    }
                }
            };
        }
    }
}

