/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import org.jrobin.core.RrdException;
import org.jrobin.data.Aggregates;
import org.jrobin.data.Source;

public class PercentileDef
extends Source {
    private Source m_source;
    private double m_value;
    private double m_percentile;
    private boolean m_ignorenan;

    PercentileDef(String name, Source source, double percentile) {
        this(name, source, percentile, false);
    }

    PercentileDef(String name, Source source, double percentile, boolean ignorenan) {
        super(name);
        this.m_percentile = percentile;
        this.m_ignorenan = ignorenan;
        this.m_source = source;
        this.setValue(Double.NaN);
    }

    public void calculate(long tStart, long tEnd) throws RrdException {
        if (this.m_source != null) {
            this.setValue(this.m_source.getPercentile(tStart, tEnd, this.m_percentile));
        }
    }

    private void setValue(double value) {
        this.m_value = value;
        long[] times = this.getTimestamps();
        if (times != null) {
            int count = times.length;
            double[] values = new double[count];
            for (int i = 0; i < count; ++i) {
                values[i] = this.m_value;
            }
            this.setValues(values);
        }
    }

    @Override
    void setTimestamps(long[] timestamps) {
        super.setTimestamps(timestamps);
        this.setValue(this.m_value);
    }

    @Override
    Aggregates getAggregates(long tStart, long tEnd) throws RrdException {
        Aggregates agg = new Aggregates();
        agg.max = agg.average = this.m_value;
        agg.min = agg.average;
        agg.last = agg.average;
        agg.first = agg.average;
        agg.total = this.m_value * (double)(tEnd - tStart);
        return agg;
    }

    @Override
    double getPercentile(long tStart, long tEnd, double percentile) throws RrdException {
        return this.m_value;
    }
}

