/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.data;

import java.util.ArrayList;
import java.util.Arrays;
import org.jrobin.core.ConsolFuns;
import org.jrobin.core.Util;
import org.jrobin.data.Aggregates;

class Aggregator
implements ConsolFuns {
    private long[] timestamps;
    private long step;
    private double[] values;

    Aggregator(long[] timestamps, double[] values) {
        assert (timestamps.length == values.length) : "Incompatible timestamps/values arrays (unequal lengths)";
        assert (timestamps.length >= 2) : "At least two timestamps must be supplied";
        this.timestamps = timestamps;
        this.values = values;
        this.step = timestamps[1] - timestamps[0];
    }

    Aggregates getAggregates(long tStart, long tEnd) {
        Aggregates agg = new Aggregates();
        int cnt = 0;
        int lslstep = 0;
        boolean firstFound = false;
        double SUMx = 0.0;
        double SUMy = 0.0;
        double SUMxy = 0.0;
        double SUMxx = 0.0;
        double SUMyy = 0.0;
        for (int i = 0; i < this.timestamps.length; ++i) {
            long left = Math.max(this.timestamps[i] - this.step, tStart);
            long right = Math.min(this.timestamps[i], tEnd);
            long delta = right - left;
            if (delta < 0L) continue;
            double value = this.values[i];
            agg.min = Util.min(agg.min, value);
            agg.max = Util.max(agg.max, value);
            if (!firstFound) {
                agg.first = value;
                firstFound = true;
                agg.last = value;
            } else if (delta >= this.step) {
                agg.last = value;
            }
            if (!Double.isNaN(value)) {
                ++cnt;
                SUMx += (double)lslstep;
                SUMxx += (double)(lslstep * lslstep);
                SUMy = Util.sum(SUMy, value);
                SUMxy = Util.sum(SUMxy, (double)lslstep * value);
                SUMyy = Util.sum(SUMyy, value * value);
            }
            ++lslstep;
        }
        double d = agg.average = cnt > 0 ? SUMy / (double)cnt : Double.NaN;
        if (cnt > 0) {
            double stdevSum = 0.0;
            for (int i = 0; i < this.timestamps.length; ++i) {
                double value;
                long left = Math.max(this.timestamps[i] - this.step, tStart);
                long right = Math.min(this.timestamps[i], tEnd);
                long delta = right - left;
                if (delta < 0L || Double.isNaN(value = this.values[i])) continue;
                stdevSum = Util.sum(stdevSum, Math.pow(value - agg.average, 2.0));
            }
            agg.stdev = Math.pow(stdevSum / (double)cnt, 0.5);
            agg.lslslope = (SUMx * SUMy - (double)cnt * SUMxy) / (SUMx * SUMx - (double)cnt * SUMxx);
            agg.lslint = (SUMy - agg.lslslope * SUMx) / (double)cnt;
            agg.lslcorrel = (SUMxy - SUMx * SUMy / (double)cnt) / Math.sqrt((SUMxx - SUMx * SUMx / (double)cnt) * (SUMyy - SUMy * SUMy / (double)cnt));
        }
        agg.total = SUMy * (double)this.step;
        return agg;
    }

    double getPercentile(long tStart, long tEnd, double percentile) {
        return this.getPercentile(tStart, tEnd, percentile, false);
    }

    double getPercentile(long tStart, long tEnd, double percentile, boolean includenan) {
        ArrayList<Double> valueList = new ArrayList<Double>();
        for (int i = 0; i < this.timestamps.length; ++i) {
            long left = Math.max(this.timestamps[i] - this.step, tStart);
            long right = Math.min(this.timestamps[i], tEnd);
            if (right <= left || Double.isNaN(this.values[i]) && !includenan) continue;
            valueList.add(this.values[i]);
        }
        int count = valueList.size();
        if (count > 1) {
            double[] valuesCopy = new double[count];
            for (int i = 0; i < count; ++i) {
                valuesCopy[i] = (Double)valueList.get(i);
            }
            Arrays.sort(valuesCopy);
            double topPercentile = (100.0 - percentile) / 100.0;
            count -= (int)Math.ceil((double)count * topPercentile);
            if (count > 0) {
                return valuesCopy[count - 1];
            }
        }
        return Double.NaN;
    }
}

