/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client.executors;

import com.google.gson.JsonSyntaxException;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.client.config.exception.CouldNotConnectException;
import java.io.IOException;
import org.opennms.features.jest.client.ConnectionPoolShutdownException;
import org.opennms.features.jest.client.RequestExecutorFactory;
import org.opennms.features.jest.client.executors.RequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestExecutor
implements RequestExecutor,
RequestExecutorFactory {
    private static Logger LOG = LoggerFactory.getLogger(DefaultRequestExecutor.class);
    private final long cooldownInMs;

    public DefaultRequestExecutor(long cooldownInMs) {
        if (cooldownInMs < 0L) {
            LOG.warn("Retry cooldown must be >= 0. Using a value of 0 instead.");
        }
        this.cooldownInMs = Math.max(0L, cooldownInMs);
    }

    @Override
    public <T extends JestResult> T execute(JestClient client, Action<T> clientRequest) {
        while (true) {
            LOG.debug("Executing request {}", clientRequest);
            try {
                JestResult result = client.execute(clientRequest);
                return (T)result;
            }
            catch (CouldNotConnectException connectException) {
                LOG.error("Could not connect to elastic endpoint: {}", (Object)connectException.getHost(), (Object)connectException);
            }
            catch (IOException ex) {
                LOG.error("Could not perform request {}: {}", new Object[]{clientRequest, ex.getMessage(), ex});
            }
            catch (JsonSyntaxException gsonException) {
                LOG.error("A Json error occurred: {}", (Object)gsonException.getMessage(), (Object)gsonException);
            }
            catch (IllegalStateException ex) {
                if (ex.getMessage().equals("Connection pool shut down")) {
                    LOG.error("Connection pool shut down. Nothing we can do. Bailing");
                    throw new ConnectionPoolShutdownException(ex.getMessage(), ex);
                }
                LOG.error("IllegalStateException occurred: {}", (Object)ex.getMessage(), (Object)ex);
            }
            LOG.debug("Request was not executed properly. Attempting Retry...");
            if (this.cooldownInMs > 0L) {
                LOG.debug("Sleep " + this.cooldownInMs + " before retrying");
                try {
                    Thread.sleep(this.cooldownInMs);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Thread interrupted.", e);
                }
            }
            LOG.debug("Retrying now");
        }
    }

    @Override
    public RequestExecutor createExecutor(int timeout, int retryCount) {
        return new DefaultRequestExecutor(this.cooldownInMs);
    }
}

