/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.PacketMultiplexListener;

class RoomListenerMultiplexor
extends AbstractConnectionListener {
    private static final Map<XMPPConnection, WeakReference<RoomListenerMultiplexor>> monitors = new WeakHashMap<XMPPConnection, WeakReference<RoomListenerMultiplexor>>();
    private XMPPConnection connection;
    private RoomMultiplexFilter filter;
    private RoomMultiplexListener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RoomListenerMultiplexor getRoomMultiplexor(XMPPConnection conn) {
        Map<XMPPConnection, WeakReference<RoomListenerMultiplexor>> map = monitors;
        synchronized (map) {
            if (!monitors.containsKey(conn) || monitors.get(conn).get() == null) {
                RoomListenerMultiplexor rm = new RoomListenerMultiplexor(conn, new RoomMultiplexFilter(), new RoomMultiplexListener());
                rm.init();
                monitors.put(conn, new WeakReference<RoomListenerMultiplexor>(rm));
            }
            return (RoomListenerMultiplexor)((Object)monitors.get(conn).get());
        }
    }

    private RoomListenerMultiplexor(XMPPConnection connection, RoomMultiplexFilter filter, RoomMultiplexListener listener) {
        if (connection == null) {
            throw new IllegalArgumentException("XMPPConnection is null");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.connection = connection;
        this.filter = filter;
        this.listener = listener;
    }

    public void addRoom(String address, PacketMultiplexListener roomListener) {
        this.filter.addRoom(address);
        this.listener.addRoom(address, roomListener);
    }

    public void connectionClosed() {
        this.cancel();
    }

    public void connectionClosedOnError(Exception e) {
        this.cancel();
    }

    public void init() {
        this.connection.addConnectionListener((ConnectionListener)this);
        this.connection.addPacketListener((PacketListener)this.listener, (PacketFilter)this.filter);
    }

    public void removeRoom(String address) {
        this.filter.removeRoom(address);
        this.listener.removeRoom(address);
    }

    private void cancel() {
        this.connection.removeConnectionListener((ConnectionListener)this);
        this.connection.removePacketListener((PacketListener)this.listener);
    }

    private static class RoomMultiplexListener
    implements PacketListener {
        private Map<String, PacketMultiplexListener> roomListenersByAddress = new ConcurrentHashMap<String, PacketMultiplexListener>();

        private RoomMultiplexListener() {
        }

        public void processPacket(Packet p) throws SmackException.NotConnectedException {
            String from = p.getFrom();
            if (from == null) {
                return;
            }
            PacketMultiplexListener listener = this.roomListenersByAddress.get(StringUtils.parseBareAddress((String)from).toLowerCase(Locale.US));
            if (listener != null) {
                listener.processPacket(p);
            }
        }

        public void addRoom(String address, PacketMultiplexListener listener) {
            if (address == null) {
                return;
            }
            this.roomListenersByAddress.put(address.toLowerCase(Locale.US), listener);
        }

        public void removeRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomListenersByAddress.remove(address.toLowerCase(Locale.US));
        }
    }

    private static class RoomMultiplexFilter
    implements PacketFilter {
        private Map<String, String> roomAddressTable = new ConcurrentHashMap<String, String>();

        private RoomMultiplexFilter() {
        }

        public boolean accept(Packet p) {
            String from = p.getFrom();
            if (from == null) {
                return false;
            }
            return this.roomAddressTable.containsKey(StringUtils.parseBareAddress((String)from).toLowerCase(Locale.US));
        }

        public void addRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomAddressTable.put(address.toLowerCase(Locale.US), address);
        }

        public void removeRoom(String address) {
            if (address == null) {
                return;
            }
            this.roomAddressTable.remove(address.toLowerCase(Locale.US));
        }
    }
}

