/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.util.Map;
import org.drools.io.FileSystemResource;
import org.kie.api.KieBase;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieSession;
import org.kie.internal.utils.KieHelper;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.ticketd.DefaultTicketerServiceLayer;
import org.opennms.netmgt.ticketd.DroolsTicketerConfigDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsTicketerServiceLayer
extends DefaultTicketerServiceLayer {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsTicketerServiceLayer.class);
    private final DroolsTicketerConfigDao m_configDao;
    private KieBase m_kieBase;

    public DroolsTicketerServiceLayer() {
        this(new DroolsTicketerConfigDao());
    }

    public DroolsTicketerServiceLayer(DroolsTicketerConfigDao configDao) {
        this.m_configDao = configDao;
        this.m_kieBase = this.createKieBase();
    }

    public DroolsTicketerConfigDao getConfigDao() {
        return this.m_configDao;
    }

    @Override
    public void reloadTicketer() {
        LOG.debug("reloadTicketer: Reloading ticketer");
        this.m_kieBase = this.createKieBase();
    }

    private KieBase createKieBase() {
        return new KieHelper().addResource((Resource)new FileSystemResource(this.m_configDao.getRulesFile())).build(new KieBaseOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Ticket createTicketFromAlarm(OnmsAlarm alarm, Map<String, String> attributes) {
        LOG.debug("Initializing ticket from alarm: {}", (Object)alarm);
        if (this.m_kieBase == null) {
            LOG.error("KieContainer is NULL, creating basic ticket from alarm.");
            return super.createTicketFromAlarm(alarm, attributes);
        }
        Ticket ticket = new Ticket();
        KieSession session = this.m_kieBase.newKieSession();
        try {
            session.setGlobal("ticket", (Object)ticket);
            session.insert((Object)alarm);
            session.insert((Object)alarm.getNode());
            session.fireAllRules();
        }
        finally {
            session.dispose();
        }
        LOG.debug("Successfully initialized ticket: {} from alarm: {}.", (Object)ticket, (Object)alarm);
        return ticket;
    }
}

