/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketd;

import java.io.File;
import java.util.Objects;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsTicketerConfigDao {
    private static final Logger LOG = LoggerFactory.getLogger(DroolsTicketerConfigDao.class);

    private static Configuration getProperties() {
        String propsFile = System.getProperty("opennms.home") + "/etc/drools-ticketer.properties";
        LOG.debug("loading properties from: {}", (Object)propsFile);
        PropertiesConfiguration config = null;
        try {
            config = new PropertiesConfiguration(propsFile);
        }
        catch (ConfigurationException e) {
            LOG.debug("Unable to load properties from {}", (Object)propsFile, (Object)e);
        }
        return config;
    }

    public File getRulesFile() {
        Configuration properties = Objects.requireNonNull(DroolsTicketerConfigDao.getProperties());
        return new File(properties.getString("drools-ticketer.rules-file"));
    }
}

