/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.pgshared;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.opennms.features.distributed.kvstore.api.AbstractAsyncKeyValueStore;

public abstract class AbstractPostgresKeyValueStore<T, S>
extends AbstractAsyncKeyValueStore<T> {
    private static final String VALUE_COLUMN = "value";
    private static final String KEY_COLUMN = "key";
    private static final String CONTEXT_COLUMN = "context";
    private static final String LAST_UPDATED_COLUMN = "last_updated";
    private static final String EXPIRES_AT_COLUMN = "expires_at";
    private final DataSource dataSource;

    public AbstractPostgresKeyValueStore(DataSource dataSource) {
        this.dataSource = Objects.requireNonNull(dataSource);
    }

    private static boolean isExpired(ResultSet resultSet) throws SQLException {
        long now = System.currentTimeMillis();
        Timestamp expiresAt = resultSet.getTimestamp(EXPIRES_AT_COLUMN);
        return expiresAt != null && expiresAt.getTime() < now;
    }

    private PreparedStatement getSelectStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("SELECT %s, %s FROM %s WHERE %s = ? AND %s = ?", VALUE_COLUMN, EXPIRES_AT_COLUMN, this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN));
    }

    private PreparedStatement getUpsertStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("INSERT INTO %s (%s, %s, %s, %s, %s) VALUES (?, ?, ?, ?, " + this.getValueStatementPlaceholder() + ") ON CONFLICT ON CONSTRAINT " + this.getPkConstraintName() + " DO UPDATE SET %s = ?, %s = ?, %s = " + this.getValueStatementPlaceholder(), this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN, LAST_UPDATED_COLUMN, EXPIRES_AT_COLUMN, VALUE_COLUMN, LAST_UPDATED_COLUMN, EXPIRES_AT_COLUMN, VALUE_COLUMN));
    }

    private PreparedStatement getLastUpdatedStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("SELECT %s, %s FROM %s WHERE %s = ? AND %s = ?", LAST_UPDATED_COLUMN, EXPIRES_AT_COLUMN, this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN));
    }

    private PreparedStatement getEnumerateStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("SELECT %s, %s, %s FROM %s WHERE %s = ?", KEY_COLUMN, VALUE_COLUMN, EXPIRES_AT_COLUMN, this.getTableName(), CONTEXT_COLUMN));
    }

    private PreparedStatement getDeleteStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("DELETE FROM %s WHERE %s = ? AND %s = ?", this.getTableName(), KEY_COLUMN, CONTEXT_COLUMN));
    }

    private PreparedStatement getTruncateStatement(Connection connection) throws SQLException {
        return connection.prepareStatement(String.format("DELETE FROM %s WHERE %s = ?", this.getTableName(), CONTEXT_COLUMN));
    }

    public long put(String key, T value, String context, Integer ttlInSeconds) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        long now = System.currentTimeMillis();
        this.withStatement(this::getUpsertStatement, upsertStatement -> {
            upsertStatement.setString(1, key);
            upsertStatement.setString(2, context);
            upsertStatement.setTimestamp(3, new Timestamp(now));
            upsertStatement.setTimestamp(6, new Timestamp(now));
            if (ttlInSeconds != null) {
                long expireTime = now + TimeUnit.MILLISECONDS.convert(ttlInSeconds.intValue(), TimeUnit.SECONDS);
                upsertStatement.setTimestamp(4, new Timestamp(expireTime));
                upsertStatement.setTimestamp(7, new Timestamp(expireTime));
            } else {
                upsertStatement.setNull(4, 91);
                upsertStatement.setNull(7, 91);
            }
            upsertStatement.setObject(5, this.getSQLTypeFromValueType(value));
            upsertStatement.setObject(8, this.getSQLTypeFromValueType(value));
            return upsertStatement.execute();
        });
        return now;
    }

    public Optional<T> get(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return this.withStatement(this::getSelectStatement, selectStatement -> {
            selectStatement.setString(1, key);
            selectStatement.setString(2, context);
            try (ResultSet resultSet = selectStatement.executeQuery();){
                if (!resultSet.next()) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                if (AbstractPostgresKeyValueStore.isExpired(resultSet)) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Optional<T> optional = Optional.of(this.getValueTypeFromSQLType(resultSet, VALUE_COLUMN));
                return optional;
            }
        });
    }

    public Optional<Optional<T>> getIfStale(String key, String context, long timestamp) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        OptionalLong lastUpdated = this.getLastUpdated(key, context);
        if (!lastUpdated.isPresent()) {
            return Optional.empty();
        }
        if (timestamp >= lastUpdated.getAsLong()) {
            return Optional.of(Optional.empty());
        }
        Optional<T> value = this.get(key, context);
        if (!value.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public OptionalLong getLastUpdated(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        return this.withStatement(this::getLastUpdatedStatement, lastUpdatedStatement -> {
            lastUpdatedStatement.setString(1, key);
            lastUpdatedStatement.setString(2, context);
            try (ResultSet resultSet = lastUpdatedStatement.executeQuery();){
                if (!resultSet.next()) {
                    OptionalLong optionalLong = OptionalLong.empty();
                    return optionalLong;
                }
                if (AbstractPostgresKeyValueStore.isExpired(resultSet)) {
                    OptionalLong optionalLong = OptionalLong.empty();
                    return optionalLong;
                }
                OptionalLong optionalLong = OptionalLong.of(resultSet.getTimestamp(LAST_UPDATED_COLUMN).getTime());
                return optionalLong;
            }
        });
    }

    public Map<String, T> enumerateContext(String context) {
        Objects.requireNonNull(context);
        return this.withStatement(this::getEnumerateStatement, enumerateStatement -> {
            HashMap<String, T> resultMap = new HashMap<String, T>();
            enumerateStatement.setString(1, context);
            try (ResultSet enumerateResult = enumerateStatement.executeQuery();){
                while (enumerateResult.next()) {
                    if (AbstractPostgresKeyValueStore.isExpired(enumerateResult)) continue;
                    resultMap.put(enumerateResult.getString(KEY_COLUMN), this.getValueTypeFromSQLType(enumerateResult, VALUE_COLUMN));
                }
            }
            return resultMap;
        });
    }

    public void delete(String key, String context) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(context);
        this.withStatement(this::getDeleteStatement, deleteStatement -> {
            deleteStatement.setString(1, key);
            deleteStatement.setString(2, context);
            return deleteStatement.execute();
        });
    }

    public void truncateContext(String context) {
        Objects.requireNonNull(context);
        this.withStatement(this::getTruncateStatement, truncateStatement -> {
            truncateStatement.setString(1, context);
            return truncateStatement.execute();
        });
    }

    protected S getSQLTypeFromValueType(T value) {
        return (S)value;
    }

    protected abstract T getValueTypeFromSQLType(ResultSet var1, String var2) throws SQLException;

    protected String getValueStatementPlaceholder() {
        return "?";
    }

    protected abstract String getTableName();

    protected abstract String getPkConstraintName();

    public String getName() {
        return "Postgres";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <U> U withStatement(ConnectionToStatement connectionToStatement, StatementToResult<U> statementToResult) {
        try (Connection connection = this.dataSource.getConnection();){
            U u;
            block14: {
                PreparedStatement statement = connectionToStatement.getStatement(connection);
                try {
                    u = statementToResult.getResult(statement);
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return u;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    private static interface ConnectionToStatement {
        public PreparedStatement getStatement(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    private static interface StatementToResult<T> {
        public T getResult(PreparedStatement var1) throws SQLException;
    }
}

