/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.icmp.proxy.PingRequest;
import org.opennms.netmgt.icmp.proxy.PingSequence;
import org.opennms.netmgt.icmp.proxy.PingSummary;
import org.opennms.netmgt.icmp.proxy.PingSummaryCalculator;

public class PingStringUtils {
    public static String renderSequence(PingRequest request, PingSequence sequence) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(sequence);
        StringBuilder builder = new StringBuilder();
        if (sequence.isTimeout()) {
            builder.append(String.format("Request timeout for icmp_seq %s", sequence.getSequenceNumber()));
        }
        if (sequence.isError()) {
            builder.append(String.format("Request error for icmp_seq %s: %s", sequence.getSequenceNumber(), sequence.getError().getMessage()));
        }
        if (sequence.isSuccess()) {
            builder.append(String.format("%s bytes from %s: icmp_seq=%d time=%.3f ms", request.getPacketSize(), request.getInetAddress(), sequence.getSequenceNumber(), sequence.getResponse().getRtt()));
        }
        return builder.toString();
    }

    public static String renderHeader(PingSummary summary) {
        return String.format("PING %s: %d data bytes", summary.getRequest().getInetAddress(), summary.getRequest().getPacketSize() - 8);
    }

    public static String renderAll(PingSummary summary) {
        StringBuilder builder = new StringBuilder();
        List<PingSequence> sequences = summary.getSequences();
        builder.append(PingStringUtils.renderHeader(summary));
        builder.append("\n");
        for (PingSequence eachSequence : sequences) {
            builder.append(PingStringUtils.renderSequence(summary.getRequest(), eachSequence));
            builder.append("\n");
        }
        if (summary.isComplete()) {
            builder.append(PingStringUtils.renderSummary(summary));
        }
        return builder.toString();
    }

    public static String renderSummary(PingSummary summary) {
        StringBuilder builder = new StringBuilder();
        PingSummaryCalculator calculator = new PingSummaryCalculator(summary.getSequences());
        builder.append("\n");
        builder.append(String.format("--- %s ping statistics ---", summary.getRequest().getInetAddress()));
        builder.append("\n");
        builder.append(String.format("%d packets transmitted, %d packets received, %.2f%% packet loss", calculator.getPacketsTransmitted(), calculator.getPacketsReceived(), calculator.getPacketLoss()));
        builder.append("\n");
        builder.append(String.format("round-trip min/avg/max/stddev = %.2f/%.2f/%.2f/%.2f ms", calculator.getMin(), calculator.getAvg(), (double)calculator.getMax(), calculator.getStdDev()));
        builder.append("\n");
        return builder.toString();
    }
}

