/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.opennms.core.network.InetAddressXmlAdapter;

@XmlRootElement(name="ip-range")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class IPRangeDTO {
    @XmlAttribute(name="begin")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress begin;
    @XmlAttribute(name="end")
    @XmlJavaTypeAdapter(value=InetAddressXmlAdapter.class)
    private InetAddress end;
    @XmlAttribute(name="retries")
    private int retries;
    @XmlAttribute(name="timeout")
    private long timeout;

    public IPRangeDTO() {
    }

    public IPRangeDTO(InetAddress begin, InetAddress end, int retries, long timeout) {
        this.begin = begin;
        this.end = end;
        this.retries = retries;
        this.timeout = timeout;
    }

    public IPRangeDTO(String begin, String end, int retries, int timeout) throws UnknownHostException {
        this(InetAddress.getByName(begin), InetAddress.getByName(end), retries, (long)timeout);
    }

    public InetAddress getBegin() {
        return this.begin;
    }

    public void setBegin(InetAddress begin) {
        this.begin = begin;
    }

    public InetAddress getEnd() {
        return this.end;
    }

    public void setEnd(InetAddress end) {
        this.end = end;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public int hashCode() {
        return Objects.hash(this.begin, this.end, this.retries, this.timeout);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPRangeDTO other = (IPRangeDTO)obj;
        return Objects.equals(this.begin, other.begin) && Objects.equals(this.end, other.end) && Objects.equals(this.retries, other.retries) && Objects.equals(this.timeout, other.timeout);
    }
}

