/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.util.Objects;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.InterfaceToNodeCache;
import org.opennms.netmgt.discovery.IpAddressFilter;

public class UnmanagedInterfaceFilter
implements IpAddressFilter {
    private final InterfaceToNodeCache interfaceToNodeCache;

    public UnmanagedInterfaceFilter(InterfaceToNodeCache interfaceToNodeCache) {
        this.interfaceToNodeCache = Objects.requireNonNull(interfaceToNodeCache);
    }

    @Override
    public boolean matches(String location, InetAddress address) {
        return this.interfaceToNodeCache.getFirstNodeId(location, address).isEmpty();
    }

    @Override
    public boolean matches(String location, String address) {
        return this.matches(location, InetAddressUtils.addr((String)address));
    }
}

