/*
 * Decompiled with CFR 0.152.
 */
package net.redhogs.cronparser;

import net.redhogs.cronparser.I18nMessages;
import net.redhogs.cronparser.Options;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateAndTimeUtils {
    private DateAndTimeUtils() {
    }

    public static String formatTime(String hoursExpression, String minutesExpression, Options opts) {
        return DateAndTimeUtils.formatTime(hoursExpression, minutesExpression, "", opts);
    }

    public static String formatTime(String hoursExpression, String minutesExpression, String secondsExpression, Options opts) {
        DateTimeFormatter timeFormat;
        LocalTime localTime;
        int hour = Integer.parseInt(hoursExpression);
        int minutes = Integer.parseInt(minutesExpression);
        if (opts.isTwentyFourHourTime()) {
            if (!StringUtils.isEmpty((CharSequence)secondsExpression)) {
                int seconds = Integer.parseInt(secondsExpression);
                localTime = new LocalTime(hour, minutes, seconds);
                timeFormat = DateTimeFormat.mediumTime();
            } else {
                localTime = new LocalTime(hour, minutes);
                timeFormat = DateTimeFormat.shortTime();
            }
        } else if (!StringUtils.isEmpty((CharSequence)secondsExpression)) {
            int seconds = Integer.parseInt(secondsExpression);
            localTime = new LocalTime(hour, minutes, seconds);
            timeFormat = DateTimeFormat.forPattern((String)"h:mm:ss a");
        } else {
            localTime = new LocalTime(hour, minutes);
            timeFormat = DateTimeFormat.forPattern((String)"h:mm a");
        }
        return localTime.toString(timeFormat.withLocale(I18nMessages.getCurrentLocale()));
    }

    public static String getDayOfWeekName(int dayOfWeek) {
        return new DateTime().withDayOfWeek(dayOfWeek).dayOfWeek().getAsText(I18nMessages.getCurrentLocale());
    }

    public static String formatMinutes(String minutesExpression) {
        if (StringUtils.contains((CharSequence)minutesExpression, (CharSequence)",")) {
            StringBuilder formattedExpression = new StringBuilder();
            for (String minute : StringUtils.split((String)minutesExpression, (char)',')) {
                formattedExpression.append(StringUtils.leftPad((String)minute, (int)2, (char)'0'));
                formattedExpression.append(",");
            }
            return formattedExpression.toString();
        }
        return StringUtils.leftPad((String)minutesExpression, (int)2, (char)'0');
    }
}

