/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.surveillanceViews;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.surveillanceViews.Category;
import org.opennms.netmgt.config.surveillanceViews.Def;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="row-def")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="surveillance-views.xsd")
public class RowDef
implements Def,
Serializable {
    private static final long serialVersionUID = 3L;
    @XmlAttribute(name="label", required=true)
    private String m_label;
    @XmlAttribute(name="report-category")
    private String m_reportCategory;
    @XmlElement(name="category", required=true)
    private List<Category> m_categories = new ArrayList<Category>();

    public RowDef() {
    }

    public RowDef(String label, String ... categories) {
        this.setLabel(label);
        for (String category : categories) {
            this.addCategory(category);
        }
    }

    @Override
    public String getLabel() {
        return this.m_label;
    }

    @Override
    public void setLabel(String label) {
        this.m_label = ConfigUtils.assertNotEmpty(label, "label");
    }

    @Override
    public Optional<String> getReportCategory() {
        return Optional.ofNullable(this.m_reportCategory);
    }

    @Override
    public void setReportCategory(String reportCategory) {
        this.m_reportCategory = ConfigUtils.normalizeString(reportCategory);
    }

    @Override
    public List<Category> getCategories() {
        return this.m_categories;
    }

    public void setCategories(List<Category> categories) {
        ConfigUtils.assertMinimumSize(categories, 1L, "category");
        if (categories == this.m_categories) {
            return;
        }
        this.m_categories.clear();
        if (categories != null) {
            this.m_categories.addAll(categories);
        }
    }

    public void addCategory(Category category) {
        this.m_categories.add(category);
    }

    public void addCategory(String category) {
        this.m_categories.add(new Category(category));
    }

    public boolean removeCategory(Category category) {
        return this.m_categories.remove(category);
    }

    @Override
    public Set<String> getCategoryNames() {
        return this.getCategories().stream().map(cat -> cat.getName()).collect(Collectors.toSet());
    }

    @Override
    public boolean containsCategory(String name) {
        return this.getCategories().stream().anyMatch(cat -> name.equals(cat.getName()));
    }

    public int hashCode() {
        return Objects.hash(this.m_label, this.m_reportCategory, this.m_categories);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RowDef) {
            RowDef that = (RowDef)obj;
            return Objects.equals(this.m_label, that.m_label) && Objects.equals(this.m_reportCategory, that.m_reportCategory) && Objects.equals(this.m_categories, that.m_categories);
        }
        return false;
    }
}

