/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.javamail;

import java.io.Serializable;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="sendmail-protocol", namespace="http://xmlns.opennms.org/xsd/config/javamail-configuration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="javamail-configuration.xsd")
public class SendmailProtocol
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlAttribute(name="char-set")
    private String m_charSet;
    @XmlAttribute(name="mailer")
    private String m_mailer;
    @XmlAttribute(name="message-content-type")
    private String m_messageContentType;
    @XmlAttribute(name="message-encoding")
    private String m_messageEncoding;
    @XmlAttribute(name="quit-wait")
    private Boolean m_quitWait;
    @XmlAttribute(name="transport")
    private String m_transport;
    @XmlAttribute(name="ssl-enable")
    private Boolean m_sslEnable;
    @XmlAttribute(name="start-tls")
    private Boolean m_startTls;

    public SendmailProtocol() {
        this.setCharSet("us-ascii");
        this.setMailer("smtpsend");
        this.setMessageContentType("text/plain");
        this.setMessageEncoding("7-bit");
        this.setTransport("smtp");
    }

    public String getCharSet() {
        return this.m_charSet == null ? "us-ascii" : this.m_charSet;
    }

    public void setCharSet(String charSet) {
        this.m_charSet = ConfigUtils.normalizeString(charSet);
    }

    public String getMailer() {
        return this.m_mailer == null ? "smtpsend" : this.m_mailer;
    }

    public void setMailer(String mailer) {
        this.m_mailer = ConfigUtils.normalizeString(mailer);
    }

    public String getMessageContentType() {
        return this.m_messageContentType == null ? "text/plain" : this.m_messageContentType;
    }

    public void setMessageContentType(String messageContentType) {
        this.m_messageContentType = ConfigUtils.normalizeString(messageContentType);
    }

    public String getMessageEncoding() {
        return this.m_messageEncoding == null ? "7-bit" : this.m_messageEncoding;
    }

    public void setMessageEncoding(String messageEncoding) {
        this.m_messageEncoding = ConfigUtils.normalizeString(messageEncoding);
    }

    public Boolean isQuitWait() {
        return this.m_quitWait == null ? Boolean.TRUE : this.m_quitWait;
    }

    public void setQuitWait(Boolean quitWait) {
        this.m_quitWait = quitWait;
    }

    public String getTransport() {
        return this.m_transport == null ? "smtp" : this.m_transport;
    }

    public void setTransport(String transport) {
        this.m_transport = ConfigUtils.normalizeString(transport);
    }

    public Boolean isSslEnable() {
        return this.m_sslEnable == null ? Boolean.FALSE : this.m_sslEnable;
    }

    public void setSslEnable(Boolean sslEnable) {
        this.m_sslEnable = sslEnable;
    }

    public Boolean isStartTls() {
        return this.m_startTls == null ? Boolean.FALSE : this.m_startTls;
    }

    public void setStartTls(Boolean startTls) {
        this.m_startTls = startTls;
    }

    public int hashCode() {
        return Objects.hash(this.m_charSet, this.m_mailer, this.m_messageContentType, this.m_messageEncoding, this.m_quitWait, this.m_transport, this.m_sslEnable, this.m_startTls);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SendmailProtocol) {
            SendmailProtocol that = (SendmailProtocol)obj;
            return Objects.equals(this.m_charSet, that.m_charSet) && Objects.equals(this.m_mailer, that.m_mailer) && Objects.equals(this.m_messageContentType, that.m_messageContentType) && Objects.equals(this.m_messageEncoding, that.m_messageEncoding) && Objects.equals(this.m_quitWait, that.m_quitWait) && Objects.equals(this.m_transport, that.m_transport) && Objects.equals(this.m_sslEnable, that.m_sslEnable) && Objects.equals(this.m_startTls, that.m_startTls);
        }
        return false;
    }
}

