/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.syslogd.SyslogFacility;
import org.opennms.netmgt.syslogd.SyslogParser;
import org.opennms.netmgt.syslogd.SyslogSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogMessage
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogMessage.class);
    private static final ThreadLocal<DateFormat> m_rfc3164Format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd HH:mm:ss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private static final ThreadLocal<DateFormat> m_rfc3339Format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return dateFormat;
        }
    };
    private Class<? extends SyslogParser> m_parserClass;
    private SyslogFacility m_facility = SyslogFacility.UNKNOWN;
    private SyslogSeverity m_severity = SyslogSeverity.UNKNOWN;
    private Integer m_version;
    private Date m_date;
    private Integer m_year;
    private Integer m_month;
    private Integer m_dayOfMonth;
    private Integer m_hourOfDay;
    private Integer m_minute;
    private Integer m_second;
    private Integer m_millisecond;
    private ZoneId m_zoneId;
    private String m_hostname;
    private String m_processName;
    private String m_processId;
    private String m_messageId;
    private String m_message;
    private final Map<String, String> m_parameters = new HashMap<String, String>();

    public SyslogMessage() {
    }

    protected SyslogMessage(SyslogFacility facility, SyslogSeverity severity, Integer version, Date date, Integer year, Integer month, Integer dayOfMonth, Integer hourOfDay, Integer minute, Integer second, Integer millisecond, ZoneId zoneId, String hostname, String processName, String processId, String messageId, String message, Map<String, String> parameters) {
        this.m_facility = facility;
        this.m_severity = severity;
        this.m_version = version;
        this.m_date = date;
        this.m_year = year;
        this.m_month = month;
        this.m_dayOfMonth = dayOfMonth;
        this.m_hourOfDay = hourOfDay;
        this.m_minute = minute;
        this.m_second = second;
        this.m_millisecond = millisecond;
        this.m_zoneId = zoneId;
        this.m_hostname = hostname;
        this.m_processName = processName;
        this.m_processId = processId;
        this.m_messageId = messageId;
        this.m_message = message;
        this.m_parameters.putAll(parameters);
    }

    public Class<? extends SyslogParser> getParserClass() {
        return this.m_parserClass;
    }

    public void setParserClass(Class<? extends SyslogParser> parser) {
        this.m_parserClass = parser;
    }

    public SyslogFacility getFacility() {
        return this.m_facility;
    }

    public void setFacility(SyslogFacility facility) {
        this.m_facility = facility;
    }

    public SyslogSeverity getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(SyslogSeverity severity) {
        this.m_severity = severity;
    }

    public Integer getVersion() {
        return this.m_version;
    }

    public void setVersion(Integer version) {
        this.m_version = version;
    }

    public Date getDate() {
        return this.m_date;
    }

    public void setDate(Date date) {
        this.m_date = date;
    }

    public Integer getYear() {
        return this.m_year;
    }

    public void setYear(Integer year) {
        this.m_year = year;
    }

    public Integer getMonth() {
        return this.m_month;
    }

    public void setMonth(Integer month) {
        this.m_month = month;
    }

    public Integer getDayOfMonth() {
        return this.m_dayOfMonth;
    }

    public void setDayOfMonth(Integer dayOfMonth) {
        this.m_dayOfMonth = dayOfMonth;
    }

    public Integer getHourOfDay() {
        return this.m_hourOfDay;
    }

    public void setHourOfDay(Integer hourOfDay) {
        this.m_hourOfDay = hourOfDay;
    }

    public Integer getMinute() {
        return this.m_minute;
    }

    public void setMinute(Integer minute) {
        this.m_minute = minute;
    }

    public Integer getSecond() {
        return this.m_second;
    }

    public void setSecond(Integer second) {
        this.m_second = second;
    }

    public Integer getMillisecond() {
        return this.m_millisecond;
    }

    public void setMillisecond(Integer millisecond) {
        this.m_millisecond = millisecond;
    }

    public ZoneId getZoneId() {
        return this.m_zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.m_zoneId = zoneId;
    }

    public String getHostName() {
        return this.m_hostname;
    }

    public void setHostName(String hostname) {
        this.m_hostname = hostname;
    }

    public InetAddress getHostAddress() {
        if (this.m_hostname != null) {
            try {
                return InetAddress.getByName(this.m_hostname);
            }
            catch (UnknownHostException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Unable to resolve hostname '{}' in syslog message", (Object)this.m_hostname, (Object)e);
                } else {
                    LOG.debug("Unable to resolve hostname '{}' in syslog message", (Object)this.m_hostname);
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Illegal argument when trying to resolve hostname '{}' in syslog message", (Object)this.m_hostname, (Object)e);
                return null;
            }
        }
        return null;
    }

    public String getProcessName() {
        return this.m_processName;
    }

    public void setProcessName(String processName) {
        this.m_processName = processName;
    }

    public String getProcessId() {
        return this.m_processId;
    }

    public void setProcessId(String processId) {
        this.m_processId = processId;
    }

    public String getMessageID() {
        return this.m_messageId;
    }

    public void setMessageID(String messageId) {
        this.m_messageId = messageId;
    }

    public String getMessage() {
        return this.m_message;
    }

    public void setMessage(String message) {
        this.m_message = message;
    }

    public void addParameter(String key, String value) {
        this.m_parameters.put(key, value);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    private int getPriorityField() {
        if (this.m_severity != null && this.m_facility != null) {
            return this.m_severity.getPriority(this.m_facility);
        }
        return 0;
    }

    public String getRfc3164FormattedDate() {
        if (this.m_date == null) {
            return null;
        }
        return m_rfc3164Format.get().format(this.m_date);
    }

    public static String getRfc3164FormattedDate(Date date) {
        if (date == null) {
            return null;
        }
        return m_rfc3164Format.get().format(date);
    }

    public String getRfc3339FormattedDate() {
        if (this.m_date == null) {
            return null;
        }
        return m_rfc3339Format.get().format(this.m_date);
    }

    public String asRfc3164Message() {
        if (this.m_processName != null) {
            if (this.m_processId != null) {
                return String.format("<%d>%s %s %s[%s]: %s", this.getPriorityField(), this.getRfc3164FormattedDate(), this.getHostName(), this.getProcessName(), this.getProcessId(), this.getMessage());
            }
            return String.format("<%d>%s %s %s: %s", this.getPriorityField(), this.getRfc3164FormattedDate(), this.getHostName(), this.getProcessName(), this.getMessage());
        }
        return String.format("<%d>%s %s %s", this.getPriorityField(), this.getRfc3164FormattedDate(), this.getHostName(), this.getMessage());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("parser", (Object)(this.m_parserClass == null ? "Unknown" : this.m_parserClass.getName())).append("facility", (Object)this.m_facility).append("severity", (Object)this.m_severity).append("version", (Object)this.m_version).append("date", (Object)this.m_date).append("year", (Object)this.m_year).append("month", (Object)this.m_month).append("dayOfMonth", (Object)this.m_dayOfMonth).append("hourOfDay", (Object)this.m_hourOfDay).append("minute", (Object)this.m_minute).append("second", (Object)this.m_second).append("millisecond", (Object)this.m_millisecond).append("zoneId", this.m_zoneId == null ? null : this.m_zoneId.getId()).append("hostname", (Object)this.m_hostname).append("message ID", (Object)this.m_messageId).append("process name", (Object)this.m_processName).append("process ID", (Object)this.m_processId).append("message", (Object)this.m_message).append("parameters", this.m_parameters).toString();
    }

    public void setParam(String key, String value) {
        throw new UnsupportedOperationException(String.format("Cannot process param %s -> %s, setting arbitrary params is not supported yet", key, value));
    }

    public void setParam(String key, Integer value) {
        throw new UnsupportedOperationException(String.format("Cannot process param %s -> %d, setting arbitrary params is not supported yet", key, value));
    }

    public SyslogMessage clone() {
        return new SyslogMessage(this.m_facility, this.m_severity, this.m_version, this.m_date, this.m_year, this.m_month, this.m_dayOfMonth, this.m_hourOfDay, this.m_minute, this.m_second, this.m_millisecond, this.m_zoneId, this.m_hostname, this.m_processName, this.m_processId, this.m_messageId, this.m_message, this.m_parameters);
    }
}

