/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.report;

import com.atlassian.oai.validator.report.EmptyValidationReport;
import com.atlassian.oai.validator.report.ValidationReport;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class MergedValidationReport
implements ValidationReport {
    private final ImmutableList<ValidationReport> reports;

    MergedValidationReport(ValidationReport validationReport1, ValidationReport validationReport2) {
        ImmutableList.Builder reportsBuilder = new ImmutableList.Builder();
        MergedValidationReport.collect((ImmutableList.Builder<ValidationReport>)reportsBuilder, validationReport1);
        MergedValidationReport.collect((ImmutableList.Builder<ValidationReport>)reportsBuilder, validationReport2);
        this.reports = reportsBuilder.build();
    }

    MergedValidationReport(List<ValidationReport> validationReports) {
        this.reports = ImmutableList.copyOf(validationReports);
    }

    @Override
    @Nonnull
    public List<ValidationReport.Message> getMessages() {
        return Collections.unmodifiableList(this.reports.stream().flatMap(r -> r.getMessages().stream()).collect(Collectors.toList()));
    }

    @Override
    public boolean hasErrors() {
        return this.reports.stream().anyMatch(ValidationReport::hasErrors);
    }

    @Override
    public ValidationReport withAdditionalContext(ValidationReport.MessageContext context) {
        return new MergedValidationReport(this.reports.stream().map(r -> r.withAdditionalContext(context)).collect(Collectors.toList()));
    }

    private ImmutableList<ValidationReport> getReports() {
        return this.reports;
    }

    private static void collect(ImmutableList.Builder<ValidationReport> reportBuilder, ValidationReport report) {
        if (report instanceof EmptyValidationReport) {
            return;
        }
        if (report instanceof MergedValidationReport) {
            reportBuilder.addAll(((MergedValidationReport)report).getReports());
            return;
        }
        reportBuilder.add((Object)report);
    }
}

