/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.fieldmapper;

import com.atlassian.jira.rest.client.api.domain.FieldSchema;
import com.atlassian.jira.rest.client.api.domain.input.ComplexIssueInputFieldValue;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.opennms.netmgt.ticketer.jira.fieldmapper.AbstractModifyableOptionKeyFieldMapper;

public class CascadingSelectFieldMapper
extends AbstractModifyableOptionKeyFieldMapper {
    public CascadingSelectFieldMapper(Supplier<Map<String, String>> optionKeySupplier) {
        super(optionKeySupplier);
    }

    @Override
    public boolean matches(FieldSchema schema) {
        return "com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect".equals(schema.getCustom());
    }

    @Override
    public Object mapToFieldValue(String fieldId, FieldSchema schema, String attributeValue) {
        String[] split;
        if (!Strings.isNullOrEmpty((String)attributeValue) && (split = attributeValue.split(",")) != null && split.length >= 1) {
            String optionKey = this.getOptionKey(fieldId, "value");
            HashMap<String, String> parentValueMap = new HashMap<String, String>();
            parentValueMap.put(optionKey, split[0]);
            ComplexIssueInputFieldValue parentValue = new ComplexIssueInputFieldValue(parentValueMap);
            if (split.length >= 2) {
                parentValue.getValuesMap().put("child", ComplexIssueInputFieldValue.with((String)optionKey, (Object)split[1]));
            }
            return parentValue;
        }
        return null;
    }
}

