/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimIssueType;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.google.common.base.Strings;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.ticketer.jira.JiraClientUtils;
import org.opennms.netmgt.ticketer.jira.commands.AbstractJiraCommand;

@Command(scope="opennms", name="jira-list-fields", description="Uses the JIRA ReST API to list all fields available")
@org.apache.karaf.shell.commands.Command(scope="opennms", name="jira-list-fields", description="Uses the JIRA ReST API to list all fields available")
@Service
public class ListFieldsCommand
extends AbstractJiraCommand
implements Action {
    @Option(name="-k", aliases={"--project-key"}, description="The project key to filter for.")
    String projectKey;
    @Option(name="-i", aliases={"--issue-type-name"}, description="The issue type name to filter for.")
    String issueTypeName;
    @Option(name="-s", aliases={"--show-all"}, description="Show all fields. By default only custom fields are shown.")
    boolean showAll = false;

    @Override
    protected void doExecute(JiraRestClient jiraRestClient) throws Exception {
        StringBuilder info = new StringBuilder();
        info.append("Fetching ");
        info.append(this.showAll ? "custom" : "all");
        info.append(" fields for ");
        info.append((String)(Strings.isNullOrEmpty((String)this.projectKey) ? "all projects" : "project with key '" + this.projectKey + "'"));
        info.append((String)(Strings.isNullOrEmpty((String)this.issueTypeName) ? " and all issue types" : " and issue type with name '" + this.issueTypeName + "'"));
        info.append(".");
        System.out.println(info.toString());
        System.out.println();
        List<CimProject> cimProjects = JiraClientUtils.getIssueMetaData(jiraRestClient, "projects.issuetypes.fields", this.issueTypeName, this.projectKey);
        Iterator iterator = cimProjects.iterator();
        if (!iterator.hasNext()) {
            System.out.println("No fields found. The user making the ReST call may not have sufficient permissions.");
            return;
        }
        String ISSUE_ROW_FORMAT = "%s fields for issue type %s (id: %s)";
        String FIELD_ROW_FORMAT = "%-30s %-20s %-10s %-10s %s";
        while (iterator.hasNext()) {
            CimProject project = (CimProject)iterator.next();
            System.out.println("Project " + project.getName() + " (" + project.getKey() + ")");
            System.out.println("------------------------------");
            Iterator issueIt = project.getIssueTypes().iterator();
            if (!issueIt.hasNext()) {
                System.out.println("No issue types found");
                continue;
            }
            while (issueIt.hasNext()) {
                CimIssueType issue = (CimIssueType)issueIt.next();
                Map<String, CimFieldInfo> fieldsMap = ListFieldsCommand.filter(issue.getFields(), this.showAll);
                System.out.println();
                System.out.println(String.format("%s fields for issue type %s (id: %s)", this.showAll ? "All" : "Custom", issue.getName(), issue.getId()));
                System.out.println("------------------------------------------------------------");
                if (fieldsMap.isEmpty()) {
                    System.out.println("No fields found");
                    continue;
                }
                List fields = fieldsMap.values().stream().sorted(Comparator.comparing(CimFieldInfo::getName)).collect(Collectors.toList());
                System.out.println(String.format("%-30s %-20s %-10s %-10s %s", "Name", "Id", "Required", "Custom", "Type"));
                for (CimFieldInfo eachField : fields) {
                    System.out.println(String.format("%-30s %-20s %-10s %-10s %s", eachField.getName(), eachField.getId(), eachField.isRequired(), ListFieldsCommand.isCustom(eachField), eachField.getSchema().getType()));
                }
            }
        }
    }

    private static Map<String, CimFieldInfo> filter(Map<String, CimFieldInfo> fields, boolean showAll) {
        if (showAll) {
            return fields;
        }
        HashMap<String, CimFieldInfo> filteredFields = new HashMap<String, CimFieldInfo>();
        for (Map.Entry<String, CimFieldInfo> eachField : fields.entrySet()) {
            if (!ListFieldsCommand.isCustom(eachField.getValue())) continue;
            filteredFields.put(eachField.getKey(), eachField.getValue());
        }
        return filteredFields;
    }

    private static boolean isCustom(CimFieldInfo info) {
        return info != null && info.getSchema() != null && info.getSchema().getCustomId() != null;
    }
}

