/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.twin.kafka.common;

import java.io.Closeable;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.errors.WakeupException;
import org.opennms.core.logging.Logging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConsumerRunner
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConsumerRunner.class);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final KafkaConsumer<String, byte[]> consumer;
    private final Consumer<ConsumerRecord<String, byte[]>> handler;
    private final Thread thread;

    public KafkaConsumerRunner(KafkaConsumer<String, byte[]> consumer, Consumer<ConsumerRecord<String, byte[]>> handler, String name) {
        this.consumer = Objects.requireNonNull(consumer);
        this.handler = Objects.requireNonNull(handler);
        this.consumer.commitSync();
        this.thread = new Thread((Runnable)this, "kafka-consumer:" + name);
        this.thread.start();
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.consumer.wakeup();
        try {
            this.thread.join();
        }
        catch (InterruptedException e) {
            LOG.error("Consumer thread interrupted", (Throwable)e);
        }
    }

    @Override
    public void run() {
        Logging.putPrefix((String)"twin");
        try {
            while (!this.closed.get()) {
                for (ConsumerRecord record : this.consumer.poll(Duration.ofMillis(100L))) {
                    this.handler.accept((ConsumerRecord<String, byte[]>)record);
                }
            }
        }
        catch (WakeupException wakeupException) {
        }
        finally {
            this.consumer.unsubscribe();
            this.consumer.close();
        }
    }
}

