/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.concurrenttrees.radix.node.util;

import com.googlecode.concurrenttrees.radix.node.Node;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class NodeUtil {
    NodeUtil() {
    }

    public static int binarySearchForEdge(AtomicReferenceArray<Node> childNodes, Character edgeFirstCharacter) {
        int low = 0;
        int high = childNodes.length() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            Node midVal = childNodes.get(mid);
            int cmp = midVal.getIncomingEdgeFirstCharacter().compareTo(edgeFirstCharacter);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static void ensureNoDuplicateEdges(List<Node> nodes) {
        HashSet<Character> uniqueChars = new HashSet<Character>(nodes.size());
        for (Node node : nodes) {
            uniqueChars.add(node.getIncomingEdgeFirstCharacter());
        }
        if (nodes.size() != uniqueChars.size()) {
            throw new IllegalStateException("Duplicate edge detected in list of nodes supplied: " + nodes);
        }
    }
}

