/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.config.ui;

import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import org.opennms.features.vaadin.dashboard.model.Wallboard;
import org.opennms.features.vaadin.dashboard.ui.wallboard.WallboardBody;

public class PreviewClickListener
implements Button.ClickListener {
    private Component m_component;
    private Wallboard m_wallboard;

    public PreviewClickListener(Component component, Wallboard wallboard) {
        this.m_component = component;
        this.m_wallboard = wallboard;
    }

    public void buttonClick(Button.ClickEvent clickEvent) {
        final Window window = new Window("Preview");
        window.setModal(true);
        window.setClosable(false);
        window.setResizable(false);
        window.setWidth("80%");
        window.setHeight("90%");
        this.m_component.getUI().addWindow(window);
        final WallboardBody wallboardBody = new WallboardBody();
        window.setContent((Component)new VerticalLayout(){
            {
                this.setMargin(true);
                this.setSpacing(true);
                this.setSizeFull();
                this.addComponent((Component)wallboardBody);
                this.setExpandRatio((Component)wallboardBody, 1.0f);
                this.addComponent((Component)new HorizontalLayout(){
                    {
                        this.setMargin(true);
                        this.setSpacing(true);
                        this.setWidth("100%");
                        Button closeButton = new Button("Close");
                        this.addComponent((Component)closeButton);
                        this.setComponentAlignment((Component)closeButton, Alignment.MIDDLE_RIGHT);
                        closeButton.addClickListener(new Button.ClickListener(){

                            public void buttonClick(Button.ClickEvent clickEvent) {
                                window.close();
                            }
                        });
                    }
                });
            }
        });
        wallboardBody.setDashletSpecs(this.m_wallboard.getDashletSpecs());
    }
}

