/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.ui.NativeSelect;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderComponent;
import org.opennms.features.vaadin.dashboard.config.ui.editors.CriteriaBuilderHelper;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;

public class AlarmConfigurationWindow
extends DashletConfigurationWindow {
    private DashletSpec m_dashletSpec;
    private NativeSelect m_boostedSeveritySelect;

    public AlarmConfigurationWindow(DashletSpec dashletSpec) {
        this.m_dashletSpec = dashletSpec;
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setHeight(100.0f, Sizeable.Unit.PERCENTAGE);
        verticalLayout.setSizeFull();
        verticalLayout.setSpacing(true);
        verticalLayout.setMargin(true);
        this.m_boostedSeveritySelect = new NativeSelect();
        this.m_boostedSeveritySelect.setCaption("Boosted Severity");
        this.m_boostedSeveritySelect.setDescription("Select the boost severity");
        this.m_boostedSeveritySelect.setMultiSelect(false);
        this.m_boostedSeveritySelect.setNullSelectionAllowed(false);
        this.m_boostedSeveritySelect.setInvalidAllowed(false);
        this.m_boostedSeveritySelect.setNewItemsAllowed(false);
        for (OnmsSeverity onmsSeverity : OnmsSeverity.values()) {
            this.m_boostedSeveritySelect.addItem((Object)onmsSeverity.name());
        }
        String boostSeverity = (String)this.m_dashletSpec.getParameters().get("boostSeverity");
        if (boostSeverity == null || "".equals(boostSeverity)) {
            boostSeverity = OnmsSeverity.CLEARED.name();
        }
        this.m_boostedSeveritySelect.setValue((Object)boostSeverity);
        verticalLayout.addComponent((Component)this.m_boostedSeveritySelect);
        CriteriaBuilderHelper criteriaBuilderHelper = new CriteriaBuilderHelper(OnmsAlarm.class, new Class[]{OnmsNode.class, OnmsEvent.class, OnmsCategory.class});
        final CriteriaBuilderComponent criteriaBuilderComponent = new CriteriaBuilderComponent(criteriaBuilderHelper, (String)this.m_dashletSpec.getParameters().get("criteria"));
        verticalLayout.addComponent((Component)criteriaBuilderComponent);
        verticalLayout.setExpandRatio((Component)criteriaBuilderComponent, 1.0f);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(true);
        buttonLayout.setSpacing(true);
        buttonLayout.setWidth("100%");
        Button cancel = new Button("Cancel");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AlarmConfigurationWindow.this.close();
            }
        });
        cancel.setDescription("Cancel editing");
        cancel.setClickShortcut(27, null);
        buttonLayout.addComponent((Component)cancel);
        buttonLayout.setExpandRatio((Component)cancel, 1.0f);
        buttonLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                AlarmConfigurationWindow.this.m_dashletSpec.getParameters().put("criteria", criteriaBuilderComponent.getCriteria());
                AlarmConfigurationWindow.this.m_dashletSpec.getParameters().put("boostSeverity", String.valueOf(AlarmConfigurationWindow.this.m_boostedSeveritySelect.getValue()));
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)AlarmConfigurationWindow.this.getUI()).notifyMessage("Data saved", "Properties");
                AlarmConfigurationWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        buttonLayout.addComponent((Component)ok);
        verticalLayout.addComponent((Component)buttonLayout);
        this.setContent((Component)verticalLayout);
    }
}

