/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.opennms.core.db.ClosableDataSource;
import org.opennms.core.db.DataSourceConfigurationFactory;
import org.opennms.core.db.HikariCPConnectionFactory;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.netmgt.config.opennmsDataSources.ConnectionPool;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataSourceFactory.class);
    private static final Class<?> DEFAULT_FACTORY_CLASS = HikariCPConnectionFactory.class;
    private static final String DEFAULT_DS_NAME = "opennms";
    private static DataSourceConfigurationFactory m_dataSourceConfigFactory;
    private static final Map<String, DataSource> m_dataSources;
    private static final List<Runnable> m_closers;

    private static ClosableDataSource parseDataSource(String dsName) {
        JdbcDataSource jdbcDataSource = m_dataSourceConfigFactory.getJdbcDataSource(dsName);
        ConnectionPool connectionPool = ConnectionPool.merge(jdbcDataSource.getConnectionPool(), m_dataSourceConfigFactory.getConnectionPool());
        String factoryClass = connectionPool.getFactory();
        ClosableDataSource dataSource = null;
        String defaultClassName = DEFAULT_FACTORY_CLASS.getName();
        try {
            Class<?> clazz = Class.forName(factoryClass);
            Constructor<?> constructor = clazz.getConstructor(JdbcDataSource.class);
            dataSource = (ClosableDataSource)constructor.newInstance(jdbcDataSource);
        }
        catch (Throwable t) {
            LOG.debug("Unable to load {}, falling back to the default dataSource ({})", new Object[]{factoryClass, defaultClassName, t});
            try {
                Constructor<?> constructor = DEFAULT_FACTORY_CLASS.getConstructor(JdbcDataSource.class);
                dataSource = (ClosableDataSource)constructor.newInstance(jdbcDataSource);
            }
            catch (Throwable cause) {
                if (DataSourceFactory.isUnfilteredConfigException(cause)) {
                    throw new IllegalArgumentException("Failed to load " + defaultClassName + " because the configuration is unfiltered. If you see this in a unit/integration test, you can ignore it.");
                }
                LOG.error("Unable to load {}.", (Object)DEFAULT_FACTORY_CLASS.getName(), (Object)cause);
                throw new IllegalArgumentException("Unable to load " + defaultClassName + ".", cause);
            }
        }
        if (connectionPool != null) {
            dataSource.setIdleTimeout(connectionPool.getIdleTimeout());
            try {
                dataSource.setLoginTimeout(connectionPool.getLoginTimeout());
            }
            catch (SQLException e) {
                LOG.warn("Exception thrown while trying to set login timeout on datasource", (Throwable)e);
            }
            dataSource.setMinPool(connectionPool.getMinPool());
            dataSource.setMaxPool(connectionPool.getMaxPool());
            dataSource.setMaxSize(connectionPool.getMaxSize());
        }
        return dataSource;
    }

    private static boolean isUnfilteredConfigException(Throwable cause) {
        if (cause.getCause() == null) {
            return cause.getMessage() != null && cause.getMessage().contains("${install.database.driver}");
        }
        if (cause.getMessage() != null && cause.getMessage().contains("${install.database.driver}")) {
            return true;
        }
        return DataSourceFactory.isUnfilteredConfigException(cause.getCause());
    }

    public static synchronized void init() throws IOException, ClassNotFoundException, PropertyVetoException, SQLException {
    }

    public static synchronized void init(final String dsName) {
        if (DataSourceFactory.isLoaded(dsName)) {
            return;
        }
        if (m_dataSourceConfigFactory == null) {
            try {
                m_dataSourceConfigFactory = new DataSourceConfigurationFactory(ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME));
            }
            catch (IOException e) {
                LOG.warn("Could not parse default data source configuration", (Throwable)e);
                m_dataSourceConfigFactory = null;
            }
        }
        try {
            final ClosableDataSource dataSource = DataSourceFactory.parseDataSource(dsName);
            m_closers.add(new Runnable(){

                @Override
                public void run() {
                    try {
                        dataSource.close();
                    }
                    catch (Throwable cause) {
                        LOG.info("Unable to close datasource {}.", (Object)dsName, (Object)cause);
                    }
                }
            });
            DataSourceFactory.setInstance(dsName, dataSource);
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("configuration is unfiltered")) {
                LOG.warn(e.getMessage());
                return;
            }
            throw e;
        }
    }

    public static synchronized boolean isDefaultDsLoaded() {
        return DataSourceFactory.isLoaded(DEFAULT_DS_NAME);
    }

    private static synchronized boolean isLoaded(String dsName) {
        return m_dataSources.containsKey(dsName);
    }

    public static DataSource getInstance() {
        return DataSourceFactory.getInstance(DEFAULT_DS_NAME);
    }

    public static synchronized DataSource getInstance(String name) {
        DataSourceFactory.init(name);
        return m_dataSources.get(name);
    }

    public static void setInstance(DataSource ds) {
        DataSourceFactory.setInstance(DEFAULT_DS_NAME, ds);
    }

    public static synchronized void setInstance(String dsName, DataSource ds) {
        DataSource oldDs = m_dataSources.put(dsName, ds);
        if (oldDs != null) {
            // empty if block
        }
    }

    public static synchronized void setDataSourceConfigurationFactory(DataSourceConfigurationFactory factory) {
        DataSourceFactory.close();
        m_dataSourceConfigFactory = factory;
    }

    public static synchronized void close() {
        for (Runnable closer : m_closers) {
            closer.run();
        }
        m_closers.clear();
        m_dataSources.clear();
    }

    static {
        m_dataSources = new ConcurrentHashMap<String, DataSource>();
        m_closers = new LinkedList<Runnable>();
    }
}

