/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.scv.shell;

import java.util.HashMap;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.features.scv.shell.AliasCompleter;

@Command(scope="opennms", name="scv-set", description="Sets and securely store the credentials for the given alias.")
@Service
public class ScvSetCommand
implements Action {
    @Reference
    public SecureCredentialsVault secureCredentialsVault;
    @Argument(index=0, name="alias", description="Alias used to retrieve the credentials.", required=true, multiValued=false)
    @Completion(value=AliasCompleter.class)
    public String alias = null;
    @Argument(index=1, name="username", description="Username to store.", required=true, multiValued=false)
    public String username = null;
    @Argument(index=2, name="password", description="Password to store.", required=true, multiValued=false)
    public String password = null;
    @Option(name="-a", description="Attributes to store with the credentials.", multiValued=true)
    public String[] attributes;

    public Object execute() throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (this.attributes != null) {
            for (String attributeKVPair : this.attributes) {
                try {
                    String[] tok = attributeKVPair.split("=");
                    properties.put(tok[0], tok[1]);
                }
                catch (Exception e) {
                    System.err.println("Invalid attribute specification: " + attributeKVPair);
                    e.printStackTrace();
                }
            }
        }
        Credentials credentials = new Credentials(this.username, this.password, properties);
        this.secureCredentialsVault.setCredentials(this.alias, credentials);
        return null;
    }
}

