/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Function;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.pathattr.Attribute;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;

public class AsPath
implements Attribute {
    public final List<Segment> segments;

    public AsPath(ByteBuf buffer, PeerFlags flags) throws InvalidPacketException {
        this.segments = BufferUtils.repeatRemaining((ByteBuf)buffer, segmentBuffer -> new Segment(segmentBuffer, flags));
    }

    @Override
    public void accept(Attribute.Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("segments", this.segments).toString();
    }

    public static class Segment {
        public final Type type;
        public final List<Long> path;

        public Segment(ByteBuf buffer, PeerFlags flags) throws InvalidPacketException {
            this.type = Type.from(BufferUtils.uint8((ByteBuf)buffer));
            this.path = BufferUtils.repeatCount((ByteBuf)buffer, (int)BufferUtils.uint8((ByteBuf)buffer), flags::parseAS);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("path", this.path).toString();
        }

        public static enum Type {
            AS_SET,
            AS_SEQUENCE,
            UNKNOWN;


            public static Type from(int type) {
                switch (type) {
                    case 1: {
                        return AS_SET;
                    }
                    case 2: {
                        return AS_SEQUENCE;
                    }
                }
                BmpParser.RATE_LIMITED_LOG.debug("Unknown AS Path Type: {}", (Object)type);
                return UNKNOWN;
            }

            public <R> R map(Function<Type, R> mapper) {
                return mapper.apply(this);
            }
        }
    }
}

