/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.karaf.extender;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.opennms.karaf.extender.Feature;

public class Repository {
    private final Path m_path;
    private final List<URI> m_featureUris;
    private final List<Feature> m_featuresBoot;
    private final URI m_mavenUri;

    public Repository(Path path, List<URI> featureUris, List<Feature> featuresBoot) throws URISyntaxException {
        this.m_path = Objects.requireNonNull(path);
        this.m_featureUris = ImmutableList.copyOf(featureUris);
        this.m_featuresBoot = ImmutableList.copyOf(featuresBoot);
        this.m_mavenUri = new URI(String.format("file:%s@id=%s%s", this.m_path.toAbsolutePath().toString(), this.m_path.getFileName().toString(), this.containsSnapshots() ? "@snapshots" : ""));
    }

    public List<URI> getFeatureUris() {
        return this.m_featureUris;
    }

    public List<Feature> getFeaturesBoot() {
        return this.m_featuresBoot;
    }

    public URI toMavenUri() {
        return this.m_mavenUri;
    }

    public boolean containsSnapshots() {
        return this.m_featureUris.stream().filter(uri -> uri.toString().contains("-SNAPSHOT")).findFirst().isPresent();
    }

    public String toString() {
        return String.format("Repository[path=%s, featureUris=%s, featuresBoot=%s]", this.m_path, this.m_featureUris, this.m_featuresBoot);
    }

    public int hashCode() {
        return Objects.hash(this.m_path, this.m_featureUris, this.m_featuresBoot);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Repository other = (Repository)obj;
        return Objects.equals(this.m_path, other.m_path) && Objects.equals(this.m_featureUris, other.m_featureUris) && Objects.equals(this.m_featuresBoot, other.m_featuresBoot);
    }
}

