/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.enlinkd.common.TopologyUpdater;
import org.opennms.netmgt.enlinkd.model.IpInterfaceTopologyEntity;
import org.opennms.netmgt.enlinkd.model.NodeTopologyEntity;
import org.opennms.netmgt.enlinkd.model.UserDefinedLink;
import org.opennms.netmgt.enlinkd.service.api.NodeTopologyService;
import org.opennms.netmgt.enlinkd.service.api.ProtocolSupported;
import org.opennms.netmgt.enlinkd.service.api.TopologyService;
import org.opennms.netmgt.enlinkd.service.api.UserDefinedLinkTopologyService;
import org.opennms.netmgt.topologies.service.api.OnmsTopology;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyDao;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyEdge;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyPort;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyProtocol;
import org.opennms.netmgt.topologies.service.api.OnmsTopologyVertex;

public class UserDefinedLinkTopologyUpdater
extends TopologyUpdater {
    private final UserDefinedLinkTopologyService udlTopologyService;

    public UserDefinedLinkTopologyUpdater(UserDefinedLinkTopologyService udlTopologyService, OnmsTopologyDao topologyDao, NodeTopologyService nodeTopologyService) {
        super((TopologyService)udlTopologyService, topologyDao, nodeTopologyService);
        this.udlTopologyService = Objects.requireNonNull(udlTopologyService);
    }

    public String getName() {
        return UserDefinedLinkTopologyUpdater.class.getName();
    }

    public OnmsTopology buildTopology() {
        OnmsTopology topology = new OnmsTopology();
        List udls = this.udlTopologyService.findAllUserDefinedLinks();
        HashSet referencedNodes = new HashSet();
        referencedNodes.addAll(udls.stream().map(UserDefinedLink::getNodeIdA).collect(Collectors.toSet()));
        referencedNodes.addAll(udls.stream().map(UserDefinedLink::getNodeIdZ).collect(Collectors.toSet()));
        Map nodeMap = this.getNodeMap();
        Map ipMap = this.getIpPrimaryMap();
        LinkedHashMap<Integer, OnmsTopologyVertex> nodeVertexMap = new LinkedHashMap<Integer, OnmsTopologyVertex>();
        for (Integer nodeId : referencedNodes) {
            OnmsTopologyVertex nodeVertex = UserDefinedLinkTopologyUpdater.create((NodeTopologyEntity)((NodeTopologyEntity)nodeMap.get(nodeId)), (IpInterfaceTopologyEntity)((IpInterfaceTopologyEntity)ipMap.get(nodeId)));
            nodeVertexMap.put(nodeId, nodeVertex);
            topology.addVertex(nodeVertex);
        }
        for (UserDefinedLink udl : udls) {
            String uniqueLinkId = Integer.toString(udl.getDbId());
            OnmsTopologyPort sourcePort = OnmsTopologyPort.create((String)(uniqueLinkId + "|A"), (OnmsTopologyVertex)((OnmsTopologyVertex)nodeVertexMap.get(udl.getNodeIdA())), null);
            sourcePort.setToolTipText(udl.getComponentLabelA());
            OnmsTopologyPort targetPort = OnmsTopologyPort.create((String)(uniqueLinkId + "|Z"), (OnmsTopologyVertex)((OnmsTopologyVertex)nodeVertexMap.get(udl.getNodeIdZ())), null);
            targetPort.setToolTipText(udl.getComponentLabelZ());
            OnmsTopologyEdge edge = OnmsTopologyEdge.create((String)uniqueLinkId, (OnmsTopologyPort)sourcePort, (OnmsTopologyPort)targetPort);
            edge.setToolTipText(udl.getLinkLabel());
            topology.addEdge(edge);
        }
        return topology;
    }

    public OnmsTopologyProtocol getProtocol() {
        return UserDefinedLinkTopologyUpdater.create((ProtocolSupported)ProtocolSupported.USERDEFINED);
    }
}

