/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.jrobin.core.RrdDb;
import org.jrobin.core.timespec.TimeParser;
import org.jrobin.core.timespec.TimeSpec;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.rrd.RrdException;
import org.opennms.netmgt.rrd.model.AbstractDS;
import org.opennms.netmgt.rrd.model.AbstractRRA;
import org.opennms.netmgt.rrd.model.v1.RRDv1;
import org.opennms.netmgt.rrd.model.v3.DS;
import org.opennms.netmgt.rrd.model.v3.RRA;
import org.opennms.netmgt.rrd.model.v3.RRADS;
import org.opennms.netmgt.rrd.model.v3.RRDv3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class RrdConvertUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RrdConvertUtils.class);

    private RrdConvertUtils() {
    }

    public static RRDv1 dumpJrb(File sourceFile) throws IOException, org.jrobin.core.RrdException {
        RrdDb jrb = new RrdDb(sourceFile, true);
        RRDv1 rrd = (RRDv1)JaxbUtils.unmarshal(RRDv1.class, (String)jrb.getXml());
        jrb.close();
        return rrd;
    }

    public static long[] getTimestamps(String startTime, String endTime) throws RrdException {
        TimeParser startParser = new TimeParser(startTime);
        TimeParser endParser = new TimeParser(endTime);
        try {
            TimeSpec specStart = startParser.parse();
            TimeSpec specEnd = endParser.parse();
            return TimeSpec.getTimestamps((TimeSpec)specStart, (TimeSpec)specEnd);
        }
        catch (Exception e) {
            throw new RrdException((Throwable)e);
        }
    }

    public static RRDv3 dumpRrd(File sourceFile) throws IOException, org.jrobin.core.RrdException {
        String rrdBinary = System.getProperty("rrd.binary");
        if (rrdBinary == null) {
            throw new IllegalArgumentException("rrd.binary property must be set");
        }
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Process process = Runtime.getRuntime().exec(new String[]{rrdBinary, "dump", sourceFile.getAbsolutePath()});
            SAXSource source = new SAXSource(xmlReader, new InputSource(new InputStreamReader(process.getInputStream())));
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{RRDv3.class});
            Unmarshaller u = jc.createUnmarshaller();
            return (RRDv3)u.unmarshal((Source)source);
        }
        catch (Exception e) {
            throw new org.jrobin.core.RrdException("Can't parse RRD Dump", (Throwable)e);
        }
    }

    public static void restoreJrb(RRDv1 rrd, File targetFile) throws IOException, org.jrobin.core.RrdException {
        File outputXmlFile = new File(String.valueOf(targetFile) + ".xml");
        JaxbUtils.marshal((Object)rrd, (Writer)new FileWriter(outputXmlFile));
        RrdDb targetJrb = new RrdDb(targetFile.getCanonicalPath(), "xml:/" + outputXmlFile.getAbsolutePath());
        targetJrb.close();
        if (!outputXmlFile.delete()) {
            LOG.warn("Could not delete file: {}", (Object)outputXmlFile.getPath());
        }
    }

    public static void restoreRrd(RRDv3 rrd, File targetFile) throws IOException, org.jrobin.core.RrdException {
        String rrdBinary = System.getProperty("rrd.binary");
        if (rrdBinary == null) {
            throw new IllegalArgumentException("rrd.binary property must be set");
        }
        try {
            File xmlDest = new File(String.valueOf(targetFile) + ".xml");
            JaxbUtils.marshal((Object)rrd, (Writer)new FileWriter(xmlDest));
            Process process = Runtime.getRuntime().exec(new String[]{rrdBinary, "restore", xmlDest.getAbsolutePath(), targetFile.getAbsolutePath()});
            process.waitFor();
            if (!xmlDest.delete()) {
                LOG.warn("Could not delete file: {}", (Object)xmlDest.getPath());
            }
        }
        catch (Exception e) {
            throw new org.jrobin.core.RrdException("Can't restore RRD", (Throwable)e);
        }
    }

    public static void convertFromRrdToJrobin(File sourceRrdFile, File targetJrobinFile) throws IOException, org.jrobin.core.RrdException {
        RRDv3 rrd = RrdConvertUtils.dumpRrd(sourceRrdFile);
        RRDv1 jrb = RrdConvertUtils.convert(rrd);
        RrdConvertUtils.restoreJrb(jrb, targetJrobinFile);
    }

    public static void convertFromJrobinToRrd(File sourceJrobinFile, File targetRrdFile) throws IOException, org.jrobin.core.RrdException {
        RRDv1 jrb = RrdConvertUtils.dumpJrb(sourceJrobinFile);
        RRDv3 rrd = RrdConvertUtils.convert(jrb);
        RrdConvertUtils.restoreRrd(rrd, targetRrdFile);
    }

    protected static RRDv3 convert(RRDv1 jrb) throws IllegalArgumentException {
        RRDv3 rrd = new RRDv3();
        rrd.setStep(jrb.getStep());
        rrd.setLastUpdate(jrb.getLastUpdate());
        for (org.opennms.netmgt.rrd.model.v1.RRA rrav1 : jrb.getRras()) {
            RRA rrav3 = new RRA();
            rrav3.setConsolidationFunction(rrav1.getConsolidationFunction().name());
            rrav3.setPdpPerRow(rrav1.getPdpPerRow());
            rrav3.setRows(rrav1.getRows());
            rrav3.getParameters().setXff(rrav1.getXff());
            for (org.opennms.netmgt.rrd.model.v1.RRADS rradsv1 : rrav1.getDataSources()) {
                RRADS rradsv3 = new RRADS();
                rradsv3.setUnknownDataPoints(rradsv1.getUnknownDataPoints());
                rradsv3.setValue(rradsv1.getValue());
                rrav3.getDataSources().add(rradsv3);
            }
            rrd.addRRA((AbstractRRA)rrav3);
        }
        for (org.opennms.netmgt.rrd.model.v1.DS dsv1 : jrb.getDataSources()) {
            DS dsv3 = new DS();
            dsv3.setName(dsv1.getName());
            dsv3.setLastDs(dsv1.getLastDs());
            dsv3.setMin(dsv1.getMax());
            dsv3.setMax(dsv1.getMax());
            dsv3.setMinHeartbeat(dsv1.getMinHeartbeat());
            dsv3.setUnknownSec(dsv1.getUnknownSec());
            dsv3.setValue(dsv1.getValue());
            dsv3.setType(dsv1.getType().value());
            rrd.addDataSource((AbstractDS)dsv3);
        }
        return rrd;
    }

    protected static RRDv1 convert(RRDv3 rrd) throws IllegalArgumentException {
        RRDv1 jrb = new RRDv1();
        jrb.setStep(rrd.getStep());
        jrb.setLastUpdate(rrd.getLastUpdate());
        for (RRA rrav3 : rrd.getRras()) {
            org.opennms.netmgt.rrd.model.v1.RRA rrav1 = new org.opennms.netmgt.rrd.model.v1.RRA();
            try {
                rrav1.setConsolidationFunction(rrav3.getConsolidationFunction().name());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("RRDv1 doesn't support the consolidation function " + rrav3.getConsolidationFunction().value());
            }
            rrav1.setPdpPerRow(rrav3.getPdpPerRow());
            rrav1.setRows(rrav3.getRows());
            rrav1.setXff(rrav3.getParameters().getXff());
            for (RRADS rradsv3 : rrav3.getDataSources()) {
                org.opennms.netmgt.rrd.model.v1.RRADS rradsv1 = new org.opennms.netmgt.rrd.model.v1.RRADS();
                rradsv1.setUnknownDataPoints(rradsv3.getUnknownDataPoints());
                rradsv1.setValue(rradsv3.getValue());
                rrav1.getDataSources().add(rradsv1);
            }
            jrb.addRRA((AbstractRRA)rrav1);
        }
        for (DS dsv3 : rrd.getDataSources()) {
            org.opennms.netmgt.rrd.model.v1.DS dsv1 = new org.opennms.netmgt.rrd.model.v1.DS();
            try {
                dsv1.setType(dsv3.getType().value());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("RRDv1 doesn't support the data source type " + dsv3.getType().value());
            }
            dsv1.setName(dsv3.getName());
            dsv1.setLastDs(dsv3.getLastDs());
            dsv1.setMin(dsv3.getMax());
            dsv1.setMax(dsv3.getMax());
            dsv1.setMinHeartbeat(dsv3.getMinHeartbeat());
            dsv1.setUnknownSec(dsv3.getUnknownSec());
            dsv1.setValue(dsv3.getValue());
            jrb.addDataSource((AbstractDS)dsv1);
        }
        return jrb;
    }
}

