/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.linkd.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.topology.api.topo.BackendGraph;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.EdgeRef;
import org.opennms.features.topology.api.topo.EdgeStatusProvider;
import org.opennms.features.topology.api.topo.Status;

public class LinkdWrappedEdgeStatusProviders
implements EdgeStatusProvider {
    private EdgeStatusProvider m_edgeStatusProvider;
    private List<EdgeStatusProvider> m_providers;

    public void init() {
        this.m_providers = new ArrayList<EdgeStatusProvider>();
        this.m_providers.add(this.m_edgeStatusProvider);
    }

    public Map<EdgeRef, Status> getStatusForEdges(BackendGraph graph, Collection<EdgeRef> edges, Criteria[] criteria) {
        HashMap<EdgeRef, Status> edgeRefStatusMap = new HashMap<EdgeRef, Status>();
        for (EdgeStatusProvider statusProvider : this.m_providers) {
            edgeRefStatusMap.putAll(statusProvider.getStatusForEdges(graph, edges, criteria));
        }
        return edgeRefStatusMap;
    }

    public String getNamespace() {
        return this.m_edgeStatusProvider.getNamespace();
    }

    public boolean contributesTo(String namespace) {
        return namespace != null && namespace.equals(this.getNamespace());
    }

    public void setEdgeStatusProvider(EdgeStatusProvider edgeStatusProvider) {
        this.m_edgeStatusProvider = edgeStatusProvider;
    }
}

