/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl.renderer;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.Vertex;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.renderer.GraphRenderer;
import org.opennms.netmgt.graph.rest.impl.converter.JsonConverterService;
import org.osgi.framework.BundleContext;

public class JsonGraphRenderer
implements GraphRenderer {
    private final BundleContext bundleContext;

    public JsonGraphRenderer(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public String getContentType() {
        return "application/json";
    }

    public String render(int identation, List<GraphContainerInfo> containerInfos) {
        JSONArray graphContainerJsonArray = new JSONArray();
        containerInfos.stream().sorted(Comparator.comparing(GraphContainerInfo::getId)).forEach(containerInfo -> {
            JSONObject jsonGraphContainerInfoObject = new JsonConverterService(this.bundleContext).convert((GraphContainerInfo)containerInfo);
            graphContainerJsonArray.put((Object)jsonGraphContainerInfoObject);
        });
        return graphContainerJsonArray.toString(identation);
    }

    public String render(int identation, ImmutableGraphContainer<?> graphContainer) {
        JSONObject jsonGraphContainer = new JsonConverterService(this.bundleContext).convert(graphContainer);
        return jsonGraphContainer.toString(identation);
    }

    public String render(int identation, ImmutableGraph<?, ?> graph) {
        JSONObject jsonGraph = new JsonConverterService(this.bundleContext).convert(graph);
        return jsonGraph.toString(identation);
    }

    public String render(int identation, Vertex vertex) {
        JSONObject jsonVertex = new JsonConverterService(this.bundleContext).convert(vertex);
        return jsonVertex.toString(identation);
    }
}

