/*
 * Decompiled with CFR 0.152.
 */
package org.openbmp.api.parsed.message;

public class Message {
    private Float version;
    private String collector_hash_id;
    private long length;
    private long records;
    private String router_hash_id;
    private String content;
    private String type;
    private String request_uuid;
    private Integer content_pos;

    public Message(String data) {
        this.parse(data);
    }

    private void parse(String data) {
        String[] headers;
        int data_end_pos = data.indexOf("\n\n");
        String header_data = data.substring(0, data_end_pos);
        this.content_pos = data_end_pos + 2;
        this.content = data.substring(this.content_pos);
        for (String header : headers = header_data.split("\n")) {
            String value = header.split(":")[1].trim();
            String attr = header.split(":")[0].trim();
            if (attr.equals("V")) {
                this.version = Float.valueOf(value);
                continue;
            }
            if (attr.equals("C_HASH_ID")) {
                this.collector_hash_id = value;
                continue;
            }
            if (attr.equals("L")) {
                this.length = Long.valueOf(value);
                continue;
            }
            if (attr.equals("R")) {
                this.records = Long.valueOf(value);
                continue;
            }
            if (attr.equals("R_HASH_ID")) {
                this.router_hash_id = value;
                continue;
            }
            if (attr.equals("T")) {
                this.type = value;
                continue;
            }
            if (!attr.equals("REQ_ID")) continue;
            this.request_uuid = value;
        }
    }

    public Float getVersion() {
        return this.version;
    }

    public String getCollector_hash_id() {
        return this.collector_hash_id;
    }

    public long getLength() {
        return this.length;
    }

    public long getRecords() {
        return this.records;
    }

    public String getRouter_hash_id() {
        return this.router_hash_id;
    }

    public Integer getContentPos() {
        return this.content_pos;
    }

    public String getType() {
        return this.type;
    }

    public String getRequest_uuid() {
        return this.request_uuid;
    }

    public String getContent() {
        return this.content;
    }
}

