/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opennms.netmgt.model.EventConfEvent;

@Entity
@Table(name="eventconf_sources")
public class EventConfSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="source_seq")
    @SequenceGenerator(name="source_seq", sequenceName="eventconf_sources_id_seq", allocationSize=1)
    private Long id;
    @Column(nullable=false, length=256)
    private String name;
    @Column(columnDefinition="text")
    private String description;
    @Column(length=128)
    private String vendor;
    @Column(name="file_order", nullable=false)
    private Integer fileOrder;
    @Column(nullable=false)
    private Boolean enabled = true;
    @Column(name="event_count")
    private Integer eventCount = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="created_time")
    private Date createdTime;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_modified")
    private Date lastModified;
    @Column(name="uploaded_by", length=256)
    private String uploadedBy;
    @OneToMany(mappedBy="source", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<EventConfEvent> events;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public Integer getFileOrder() {
        return this.fileOrder;
    }

    public void setFileOrder(Integer fileOrder) {
        this.fileOrder = fileOrder;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getEventCount() {
        return this.eventCount;
    }

    public void setEventCount(Integer eventCount) {
        this.eventCount = eventCount;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public String getUploadedBy() {
        return this.uploadedBy;
    }

    public void setUploadedBy(String uploadedBy) {
        this.uploadedBy = uploadedBy;
    }

    public List<EventConfEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<EventConfEvent> events) {
        this.events = events;
    }
}

