/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.validation;

import com.google.common.base.Strings;
import com.google.common.net.InetAddresses;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.core.network.IPAddress;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.error.Errors;
import org.opennms.netmgt.flows.classification.exception.InvalidRuleException;
import org.opennms.netmgt.flows.classification.internal.value.IpValue;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;
import org.opennms.netmgt.flows.classification.persistence.api.Protocols;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;

public class RuleValidator {
    private static final Pattern PORT_PATTERN = Pattern.compile("^\\d+((-|,)\\d+)*$");
    private final FilterService filterService;

    public RuleValidator(FilterService filterService) {
        this.filterService = Objects.requireNonNull(filterService);
    }

    public void validate(Rule rule) throws InvalidRuleException {
        if (rule.getGroup() == null) {
            throw new InvalidRuleException("entity", Errors.RULE_GROUP_IS_REQUIRED, new Object[0]);
        }
        RuleValidator.validateName(rule.getName());
        if (!rule.hasDefinition()) {
            throw new InvalidRuleException("entity", Errors.RULE_NO_DEFINITIONS, new Object[0]);
        }
        if (rule.hasProtocolDefinition()) {
            RuleValidator.validateProtocol(rule.getProtocol());
        }
        if (rule.hasDstPortDefinition()) {
            RuleValidator.validatePort("dstPort", rule.getDstPort());
        }
        if (rule.hasDstAddressDefinition()) {
            RuleValidator.validateIpAddress("dstAddress", rule.getDstAddress());
        }
        if (rule.hasSrcPortDefinition()) {
            RuleValidator.validatePort("srcPort", rule.getSrcPort());
        }
        if (rule.hasSrcAddressDefinition()) {
            RuleValidator.validateIpAddress("srcAddress", rule.getSrcAddress());
        }
        if (rule.hasExportFilterDefinition()) {
            this.filterService.validate(rule.getExporterFilter());
        }
    }

    protected static void validateName(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new InvalidRuleException("name", Errors.RULE_NAME_IS_REQUIRED, new Object[0]);
        }
    }

    protected static void validateProtocol(String protocol) throws InvalidRuleException {
        if (Strings.isNullOrEmpty((String)protocol)) {
            throw new InvalidRuleException("protocol", Errors.RULE_PROTOCOL_IS_REQUIRED, new Object[0]);
        }
        for (StringValue eachProtocol : new StringValue(protocol).splitBy(",")) {
            if (Protocols.getProtocol((String)eachProtocol.getValue()) != null) continue;
            throw new InvalidRuleException("protocol", Errors.RULE_PROTOCOL_DOES_NOT_EXIST, new Object[]{eachProtocol.getValue()});
        }
    }

    protected static void validatePort(String errorContext, String port) throws InvalidRuleException {
        StringValue portValue = new StringValue(port);
        if (portValue.isNullOrEmpty()) {
            throw new InvalidRuleException(errorContext, Errors.RULE_PORT_IS_REQUIRED, new Object[0]);
        }
        if (portValue.hasWildcard()) {
            throw new InvalidRuleException(errorContext, Errors.RULE_PORT_NO_WILDCARD, new Object[0]);
        }
        Matcher matcher = PORT_PATTERN.matcher(port);
        if (!matcher.matches()) {
            throw new InvalidRuleException(errorContext, Errors.RULE_PORT_DEFINITION_NOT_VALID, new Object[0]);
        }
        List<StringValue> portValues = portValue.splitBy(",");
        List<StringValue> rangedPortValues = portValues.stream().filter(v -> v.isRanged()).collect(Collectors.toList());
        rangedPortValues.forEach(v -> portValues.remove(v));
        for (StringValue eachRange : rangedPortValues) {
            int higherBound;
            List<StringValue> range = eachRange.splitBy("-");
            for (int i = 0; i < Math.min(range.size(), 2); ++i) {
                RuleValidator.verifyPortValue(errorContext, range.get(i).getValue());
            }
            int lowerBound = Integer.parseInt(range.get(0).getValue());
            if (lowerBound <= (higherBound = range.size() == 1 ? lowerBound : Integer.parseInt(range.get(1).getValue()))) continue;
            throw new InvalidRuleException(errorContext, Errors.RULE_PORT_RANGE_BOUNDS_NOT_VALID, new Object[0]);
        }
        for (StringValue eachPort : portValues) {
            RuleValidator.verifyPortValue(errorContext, eachPort.getValue());
        }
    }

    protected static void validateIpAddress(String errorContext, String ipAddressValue) throws InvalidRuleException {
        if (Strings.isNullOrEmpty((String)ipAddressValue)) {
            throw new InvalidRuleException(errorContext, Errors.RULE_IP_ADDRESS_INVALID, new Object[]{ipAddressValue});
        }
        StringValue inputValue = new StringValue(ipAddressValue);
        List<StringValue> actualValues = inputValue.splitBy(",");
        for (StringValue eachValue : actualValues) {
            if (eachValue.isRanged()) {
                IPAddress end;
                List<StringValue> rangedValues = eachValue.splitBy("-");
                if (rangedValues.size() != 2) {
                    throw new InvalidRuleException(errorContext, Errors.RULE_IP_ADDRESS_RANGE_INVALID, new Object[]{eachValue.getValue()});
                }
                for (StringValue rangedValue : rangedValues) {
                    if (rangedValue.contains("/")) {
                        throw new InvalidRuleException(errorContext, Errors.RULE_IP_ADDRESS_RANGE_CIDR_NOT_SUPPORTED, new Object[0]);
                    }
                    RuleValidator.verifyIpAddress(errorContext, rangedValue.getValue());
                }
                IPAddress begin = new IPAddress(rangedValues.get(0).getValue());
                if (!begin.isGreaterThan(end = new IPAddress(rangedValues.get(1).getValue()))) continue;
                throw new InvalidRuleException(errorContext, Errors.RULE_IP_ADDRESS_RANGE_BEGIN_END_INVALID, new Object[]{begin, end});
            }
            if (eachValue.contains("/")) {
                RuleValidator.verifyCidrExpression(errorContext, eachValue.getValue());
                continue;
            }
            RuleValidator.verifyIpAddress(errorContext, eachValue.getValue());
        }
    }

    private static void verifyPortValue(String errorContext, String input) throws InvalidRuleException {
        int value = Integer.parseInt(input);
        if (value < 0 || value > 65535) {
            throw new InvalidRuleException(errorContext, Errors.RULE_PORT_VALUE_NOT_IN_RANGE, new Object[]{0, 65535});
        }
    }

    private static void verifyIpAddress(String errorContext, String input) throws InvalidRuleException {
        if (!InetAddresses.isInetAddress((String)input)) {
            throw new InvalidRuleException(errorContext, Errors.RULE_IP_ADDRESS_INVALID, new Object[]{input});
        }
    }

    private static void verifyCidrExpression(String errorContext, String input) {
        try {
            IpValue.parseCIDR(input);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidRuleException(errorContext, Errors.RULE_IP_ADDRESS_INVALID_CIDR_EXPRESSION, new Object[]{input, ex.getMessage()});
        }
    }
}

