/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tracing.jaeger;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.jaegertracing.internal.propagation.TextMapCodec;
import io.jaegertracing.spi.Extractor;
import io.jaegertracing.spi.Injector;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.tracing.api.TracerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaegerTracerWrapper
implements TracerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(JaegerTracerWrapper.class);
    private static final String JAEGER_SAMPLER_PARAM_PROPERTY = "JAEGER_SAMPLER_PARAM";
    private static final int JAEGER_SAMPLER_PARAM_VALUE = SystemProperties.getInteger((String)"JAEGER_SAMPLER_PARAM", (int)1);
    private static final String JAEGER_SAMPLER_TYPE_PROPERTY = "JAEGER_SAMPLER_TYPE";
    private static final String JAEGER_SAMPLER_TYPE_VALUE = System.getProperty("JAEGER_SAMPLER_TYPE", "const");

    public Tracer init(String serviceName) {
        Configuration.SamplerConfiguration samplerConfig = Configuration.SamplerConfiguration.fromEnv().withType(JAEGER_SAMPLER_TYPE_VALUE).withParam((Number)JAEGER_SAMPLER_PARAM_VALUE);
        Configuration.ReporterConfiguration reporterConfig = Configuration.ReporterConfiguration.fromEnv().withLogSpans(Boolean.valueOf(true));
        Configuration config = new Configuration(serviceName).withSampler(samplerConfig).withReporter(reporterConfig);
        TextMapCodec textMapCodec = new TextMapCodec.Builder().build();
        JaegerTracer tracer = config.getTracerBuilder().registerInjector(Format.Builtin.TEXT_MAP, (Injector)textMapCodec).registerExtractor(Format.Builtin.TEXT_MAP, (Extractor)textMapCodec).build();
        GlobalTracer.registerIfAbsent((Tracer)tracer);
        LOG.info("Jaeger tracer initialized with serviceName = {}", (Object)serviceName);
        return tracer;
    }
}

