/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.plugins.topo.asset.layers;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.features.topology.plugins.topo.asset.NodeProvider;
import org.opennms.features.topology.plugins.topo.asset.layers.LayerDefinition;
import org.opennms.netmgt.dao.api.GenericPersistenceAccessor;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceNodeProvider
implements NodeProvider {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceNodeProvider.class);
    private final GenericPersistenceAccessor genericPersistenceAccessor;

    public PersistenceNodeProvider(GenericPersistenceAccessor genericPersistenceAccessor) {
        this.genericPersistenceAccessor = genericPersistenceAccessor;
    }

    @Override
    public List<OnmsNode> getNodes(List<LayerDefinition> definitions) {
        StringBuilder queryBuilder = new StringBuilder("Select n from OnmsNode n join n.assetRecord assetRecord");
        List restrictions = definitions.stream().map(LayerDefinition::getRestriction).filter(Objects::nonNull).collect(Collectors.toList());
        if (!restrictions.isEmpty()) {
            queryBuilder.append(" WHERE ");
            queryBuilder.append(restrictions.stream().map(restriction -> "n." + restriction).collect(Collectors.joining(" AND ")));
        }
        String query = queryBuilder.toString();
        LOG.debug("Query to fetch nodes to build topology from: {}", (Object)query);
        return this.genericPersistenceAccessor.find(query);
    }
}

