/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.core;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.karaf.scheduler.Scheduler;
import org.apache.karaf.scheduler.core.QuartzScheduler;
import org.apache.karaf.scheduler.core.SchedulerMBeanImpl;
import org.apache.karaf.scheduler.core.WhiteboardHandler;
import org.apache.karaf.util.tracker.BaseActivator;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.osgi.service.cm.ManagedService;

@Services(provides={@ProvideService(value=Scheduler.class)})
@Managed(value="org.apache.karaf.scheduler.quartz")
public class Activator
extends BaseActivator
implements ManagedService {
    private QuartzScheduler scheduler;
    private WhiteboardHandler whiteboardHandler;

    @Override
    protected void doStart() throws Exception {
        Properties properties = new Properties();
        if (this.getConfiguration() == null) {
            return;
        }
        Enumeration<String> keys = this.getConfiguration().keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith("org.quartz")) continue;
            Object value = this.getConfiguration().get(key);
            properties.put(key, value);
        }
        this.scheduler = new QuartzScheduler(properties);
        this.register(Scheduler.class, this.scheduler);
        this.whiteboardHandler = new WhiteboardHandler(this.bundleContext, this.scheduler);
        SchedulerMBeanImpl mBean = new SchedulerMBeanImpl();
        mBean.setScheduler(this.scheduler);
        this.registerMBean(mBean, "type=scheduler");
    }

    @Override
    protected void doStop() {
        super.doStop();
        if (this.whiteboardHandler != null) {
            this.whiteboardHandler.deactivate();
            this.whiteboardHandler = null;
        }
        if (this.scheduler != null) {
            this.scheduler.deactivate();
            this.scheduler = null;
        }
        super.doStop();
    }
}

