/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.flows;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.opennms.integration.api.v1.annotations.Model;

@Model
public interface Flow {
    public String getApplication();

    public String getHost();

    public String getLocation();

    public Locality getSrcLocality();

    public Locality getDstLocality();

    public Locality getFlowLocality();

    public NodeInfo getSrcNodeInfo();

    public NodeInfo getDstNodeInfo();

    public NodeInfo getExporterNodeInfo();

    public Duration getClockCorrection();

    public Instant getTimestamp();

    public Instant getFirstSwitched();

    public Instant getDeltaSwitched();

    public Instant getLastSwitched();

    public Instant getReceivedAt();

    public Long getBytes();

    public Direction getDirection();

    public String getDstAddr();

    public Optional<String> getDstAddrHostname();

    public Long getDstAs();

    public Integer getDstMaskLen();

    public Integer getDstPort();

    public Integer getEngineId();

    public Integer getEngineType();

    public int getFlowRecords();

    public long getFlowSeqNum();

    public Integer getInputSnmp();

    public Integer getIpProtocolVersion();

    public String getNextHop();

    public Optional<String> getNextHopHostname();

    public Integer getOutputSnmp();

    public Long getPackets();

    public Integer getProtocol();

    public SamplingAlgorithm getSamplingAlgorithm();

    public Double getSamplingInterval();

    public String getSrcAddr();

    public Optional<String> getSrcAddrHostname();

    public Long getSrcAs();

    public Integer getSrcMaskLen();

    public Integer getSrcPort();

    public Integer getTcpFlags();

    public Integer getTos();

    public NetflowVersion getNetflowVersion();

    public Integer getVlan();

    public Integer getDscp();

    public Integer getEcn();

    public String getConvoKey();

    @Model
    public static enum SamplingAlgorithm {
        Unassigned,
        SystematicCountBasedSampling,
        SystematicTimeBasedSampling,
        RandomNOutOfNSampling,
        UniformProbabilisticSampling,
        PropertyMatchFiltering,
        HashBasedFiltering,
        FlowStateDependentIntermediateFlowSelectionProcess;

    }

    @Model
    public static enum Direction {
        INGRESS,
        EGRESS,
        UNKNOWN;

    }

    @Model
    public static enum NetflowVersion {
        V5,
        V9,
        IPFIX,
        SFLOW;

    }

    @Model
    public static interface NodeInfo {
        public int getInterfaceId();

        public int getNodeId();

        public String getForeignId();

        public String getForeignSource();

        public List<String> getCategories();
    }

    @Model
    public static enum Locality {
        PUBLIC,
        PRIVATE;

    }
}

