/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.sanitizer;

import java.io.File;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opennms.systemreport.sanitizer.ConfigFileSanitizer;
import org.opennms.systemreport.sanitizer.FileSanitizationException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlFileSanitizer
implements ConfigFileSanitizer {
    private final XPath xPath;
    private final DocumentBuilder builder;
    private final Transformer transformer;
    protected final Set<String> ATTRIBUTES_TO_SANITIZE = new LinkedHashSet<String>(Arrays.asList("password", "authen-password", "oauth-consumer-secret", "oauth-access-token-secret", "writeCommunity", "auth-passphrase", "privacy-passphrase", "read-community", "write-community"));
    protected final Set<String> PARAM_KEYS_TO_SANITIZE = new LinkedHashSet<String>(Arrays.asList("password", "j_password", "login:command/password"));
    protected final Set<String> TAGS_TO_SANITIZE = new LinkedHashSet<String>(Arrays.asList("password", "login-password"));
    protected final String SANITIZED_VALUE = "***";

    public XmlFileSanitizer() throws ParserConfigurationException, TransformerConfigurationException {
        this.xPath = XPathFactory.newInstance().newXPath();
        this.builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.transformer = TransformerFactory.newInstance().newTransformer();
    }

    @Override
    public String getFileName() {
        return "*.xml";
    }

    @Override
    public Resource getSanitizedResource(File file) throws FileSanitizationException {
        try {
            Document doc = this.builder.parse(file);
            this.sanitizeXmlDocument(doc);
            StringWriter output = new StringWriter();
            this.transformer.transform(new DOMSource(doc), new StreamResult(output));
            return new ByteArrayResource(((Object)output).toString().getBytes());
        }
        catch (SAXException e) {
            throw new FileSanitizationException("Could not parse XML file", e);
        }
        catch (Exception e) {
            throw new FileSanitizationException("Could not sanitize file", e);
        }
    }

    protected void sanitizeXmlDocument(Document doc) throws SAXException, XPathExpressionException {
        Element rootNode = doc.getDocumentElement();
        for (String attribute : this.ATTRIBUTES_TO_SANITIZE) {
            this.replaceAttribute(rootNode, attribute);
        }
        for (String paramKey : this.PARAM_KEYS_TO_SANITIZE) {
            this.replaceParamValue(rootNode, paramKey);
        }
        for (String tag : this.TAGS_TO_SANITIZE) {
            this.replaceTagValue(rootNode, tag);
        }
    }

    private void replaceAttribute(Node rootNode, String attributeName) throws XPathExpressionException {
        NodeList nodesWithAttribute = (NodeList)this.xPath.evaluate(String.format("//*[@%s]", attributeName), rootNode, XPathConstants.NODESET);
        for (int i = 0; i < nodesWithAttribute.getLength(); ++i) {
            nodesWithAttribute.item(i).getAttributes().getNamedItem(attributeName).setNodeValue("***");
        }
    }

    private void replaceParamValue(Node rootNode, String keyName) throws XPathExpressionException {
        NodeList nodesWithAttribute = (NodeList)this.xPath.evaluate(String.format("//*[@key='%s']", keyName), rootNode, XPathConstants.NODESET);
        for (int i = 0; i < nodesWithAttribute.getLength(); ++i) {
            if (nodesWithAttribute.item(i).getAttributes().getNamedItem("value") == null) continue;
            nodesWithAttribute.item(i).getAttributes().getNamedItem("value").setNodeValue("***");
        }
    }

    private void replaceTagValue(Node rootNode, String tagName) throws XPathExpressionException {
        NodeList nodesWithAttribute = (NodeList)this.xPath.evaluate(String.format("//%s", tagName), rootNode, XPathConstants.NODESET);
        for (int i = 0; i < nodesWithAttribute.getLength(); ++i) {
            nodesWithAttribute.item(i).setTextContent("***");
        }
    }
}

