/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.opennms;

import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.opennms.systemreport.AbstractSystemReportPlugin;
import org.opennms.systemreport.sanitizer.ConfigurationSanitizer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class ConfigurationReportPlugin
extends AbstractSystemReportPlugin {
    @Autowired
    private ConfigurationSanitizer configurationSanitizer;

    @Override
    public String getName() {
        return "Configuration";
    }

    @Override
    public String getDescription() {
        return "Append all OpenNMS configuration files (full output only)";
    }

    @Override
    public int getPriority() {
        return 20;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean getFullOutputOnly() {
        return true;
    }

    @Override
    public boolean getOutputsFiles() {
        return true;
    }

    @Override
    public Map<String, Resource> getEntries() {
        TreeMap<String, Resource> map = new TreeMap<String, Resource>();
        File f = new File(System.getProperty("opennms.home") + File.separator + "etc");
        this.processFile(f, map);
        return map;
    }

    public void processFile(File file, Map<String, Resource> map) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.processFile(f, map);
            }
        } else {
            String filename = file.getPath();
            if ((filename = filename.replaceFirst("^" + System.getProperty("opennms.home") + File.separator + "etc" + File.separator + "?", "")).contains(File.separator + "examples" + File.separator)) {
                return;
            }
            if (filename.contains(File.separator + ".git" + File.separator)) {
                return;
            }
            if (file.length() < 1L) {
                return;
            }
            map.put(filename, this.configurationSanitizer.getSanitizedResource(file));
        }
    }
}

