/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.Date;
import org.opennms.netmgt.dao.api.ResourceReferenceDao;
import org.opennms.netmgt.dao.api.StatisticsReportDao;
import org.opennms.netmgt.model.AttributeStatistic;
import org.opennms.netmgt.model.ResourceReference;
import org.opennms.netmgt.model.StatisticsReport;
import org.opennms.netmgt.model.StatisticsReportData;
import org.opennms.netmgt.statsd.ReportInstance;
import org.opennms.netmgt.statsd.ReportPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DatabaseReportPersister
implements ReportPersister,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseReportPersister.class);
    private StatisticsReportDao m_statisticsReportDao;
    private ResourceReferenceDao m_resourceReferenceDao;

    @Override
    public void persist(ReportInstance report) {
        StatisticsReport dbReport = new StatisticsReport();
        dbReport.setName(report.getName());
        dbReport.setDescription(report.getDescription());
        dbReport.setStartDate(new Date(report.getStartTime()));
        dbReport.setEndDate(new Date(report.getEndTime()));
        dbReport.setJobStartedDate(report.getJobStartedDate());
        dbReport.setJobCompletedDate(report.getJobCompletedDate());
        dbReport.setPurgeDate(new Date(report.getJobCompletedDate().getTime() + report.getRetainInterval()));
        for (AttributeStatistic stat : report.getResults()) {
            ResourceReference resource = this.getResourceReference(stat.getAttribute().getResource().getId().toString());
            StatisticsReportData data = new StatisticsReportData();
            data.setResource(resource);
            data.setReport(dbReport);
            data.setValue(stat.getStatistic());
            dbReport.addData(data);
            LOG.debug("Adding {}", (Object)data);
        }
        if (dbReport.getData().isEmpty()) {
            LOG.warn("Cannot store {} because it doesn't contain data. Probably all the metrics are NaN for the report period.", (Object)report);
        } else {
            this.m_statisticsReportDao.save((Object)dbReport);
        }
    }

    private ResourceReference getResourceReference(String id) {
        ResourceReference resource = this.m_resourceReferenceDao.getByResourceId(id);
        if (resource != null) {
            return resource;
        }
        resource = new ResourceReference();
        resource.setResourceId(id);
        this.m_resourceReferenceDao.save((Object)resource);
        return resource;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_statisticsReportDao != null ? 1 : 0) != 0, (String)"property statisticsReportDao must be set to a non-null value");
        Assert.state((this.m_resourceReferenceDao != null ? 1 : 0) != 0, (String)"property resourceReferenceDao must be set to a non-null value");
    }

    public StatisticsReportDao getStatisticsReportDao() {
        return this.m_statisticsReportDao;
    }

    public void setStatisticsReportDao(StatisticsReportDao statisticsReportDao) {
        this.m_statisticsReportDao = statisticsReportDao;
    }

    public ResourceReferenceDao getResourceReferenceDao() {
        return this.m_resourceReferenceDao;
    }

    public void setResourceReferenceDao(ResourceReferenceDao resourceReferenceDao) {
        this.m_resourceReferenceDao = resourceReferenceDao;
    }
}

