/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.SnmpMonitorStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LaTableMonitor
extends SnmpMonitorStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(LaTableMonitor.class);
    private static final String laTableErrorFlag = "1.3.6.1.4.1.2021.10.1.100";
    private static final String laTableErrorMsg = "1.3.6.1.4.1.2021.10.1.101";

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        PollStatus status = PollStatus.available();
        InetAddress ipaddr = svc.getAddress();
        ArrayList<String> errorStringReturn = new ArrayList<String>();
        SnmpAgentConfig agentConfig = this.getAgentConfig(svc, parameters);
        String hostAddress = InetAddressUtils.str((InetAddress)ipaddr);
        LOG.debug("poll: setting SNMP peer attribute for interface {}", (Object)hostAddress);
        agentConfig.setTimeout(ParameterMap.getKeyedInteger(parameters, (String)"timeout", (int)agentConfig.getTimeout()));
        agentConfig.setRetries(ParameterMap.getKeyedInteger(parameters, (String)"retry", (int)ParameterMap.getKeyedInteger(parameters, (String)"retries", (int)agentConfig.getRetries())));
        agentConfig.setPort(ParameterMap.getKeyedInteger(parameters, (String)"port", (int)agentConfig.getPort()));
        LOG.debug("poll: service= SNMP address= {}", (Object)agentConfig);
        try {
            LOG.debug("PrTableMonitor.poll: SnmpAgentConfig address: {}", (Object)agentConfig);
            SnmpObjId laTableErrorSnmpObject = SnmpObjId.get((String)laTableErrorFlag);
            Map flagResults = SnmpUtils.getOidValues((SnmpAgentConfig)agentConfig, (String)"LaTableMonitor", (SnmpObjId)laTableErrorSnmpObject);
            if (flagResults.size() == 0) {
                LOG.debug("SNMP poll failed: no results, addr={} oid={}", (Object)hostAddress, (Object)laTableErrorSnmpObject);
                return PollStatus.unavailable();
            }
            for (Map.Entry e : flagResults.entrySet()) {
                LOG.debug("poll: SNMPwalk poll succeeded, addr={} oid={} instance={} value={}", new Object[]{hostAddress, laTableErrorSnmpObject, e.getKey(), e.getValue()});
                if (!((SnmpValue)e.getValue()).toString().equals("1")) continue;
                LOG.debug("LaTableMonitor.poll: found errorFlag=1");
                SnmpObjId laTableErrorMsgSnmpObject = SnmpObjId.get((String)("1.3.6.1.4.1.2021.10.1.101." + ((SnmpInstId)e.getKey()).toString()));
                String LaErrorMsg = SnmpUtils.get((SnmpAgentConfig)agentConfig, (SnmpObjId)laTableErrorMsgSnmpObject).toDisplayString();
                errorStringReturn.add(LaErrorMsg);
            }
            if (errorStringReturn.size() > 0) {
                return PollStatus.unavailable(errorStringReturn.toString());
            }
            return status;
        }
        catch (NumberFormatException e) {
            String reason1 = "Number operator used on a non-number " + e.getMessage();
            LOG.error(reason1, (Throwable)e);
            return PollStatus.unavailable(reason1);
        }
        catch (IllegalArgumentException e) {
            String reason1 = "Invalid SNMP Criteria: " + e.getMessage();
            LOG.error(reason1, (Throwable)e);
            return PollStatus.unavailable(reason1);
        }
        catch (Throwable t) {
            String reason1 = "Unexpected exception during SNMP poll of interface " + hostAddress;
            LOG.warn(reason1);
            return PollStatus.unavailable(reason1);
        }
    }
}

