/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Map;
import org.opennms.core.utils.ExecRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class GpMonitor
extends AbstractServiceMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(GpMonitor.class);
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        LOG.warn("GpMonitor: This poller monitor is deprecated in favor of SystemExecuteMonitor. GpMonitor will be removed in a future release.");
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        String hoption = ParameterMap.getKeyedString(parameters, (String)"hoption", (String)"--hostname");
        String toption = ParameterMap.getKeyedString(parameters, (String)"toption", (String)"--timeout");
        String args = ParameterMap.getKeyedString(parameters, (String)"args", null);
        String script = ParameterMap.getKeyedString(parameters, (String)"script", null);
        if (script == null) {
            throw new RuntimeException("GpMonitor: required parameter 'script' is not present in supplied properties.");
        }
        String strBannerMatch = (String)parameters.get("banner");
        String scriptoutput = "";
        String scripterror = "";
        InetAddress ipAddr = svc.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOG.debug("poll: address = {}, script = {}, arguments = {}, {}", new Object[]{hostAddress, script, args, tracker});
        PollStatus serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            try {
                String reason;
                tracker.startAttempt();
                int exitStatus = 100;
                int timeoutInSeconds = (int)tracker.getTimeoutInSeconds();
                ExecRunner er = new ExecRunner();
                er.setMaxRunTimeSecs(timeoutInSeconds);
                exitStatus = args == null ? er.exec(script + " " + hoption + " " + hostAddress + " " + toption + " " + timeoutInSeconds) : er.exec(script + " " + hoption + " " + hostAddress + " " + toption + " " + timeoutInSeconds + " " + args);
                double responseTime = tracker.elapsedTimeInMillis();
                if (exitStatus != 0) {
                    scriptoutput = er.getOutString();
                    reason = script + " failed with exit code " + exitStatus + ". Standard out: " + scriptoutput;
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable(reason);
                }
                if (er.isMaxRunTimeExceeded()) {
                    reason = script + " failed. Timeout exceeded";
                    LOG.debug(reason);
                    serviceStatus = PollStatus.unavailable(reason);
                } else if (exitStatus == 0) {
                    scriptoutput = er.getOutString();
                    scripterror = er.getErrString();
                    if (!scriptoutput.equals("")) {
                        LOG.debug("{} output  = {}", (Object)script, (Object)scriptoutput);
                    } else {
                        LOG.debug("{} returned no output", (Object)script);
                    }
                    if (!scripterror.equals("")) {
                        LOG.debug("{} error = {}", (Object)script, (Object)scripterror);
                    }
                    serviceStatus = strBannerMatch == null || strBannerMatch.equals("*") ? PollStatus.available(responseTime) : (scriptoutput.indexOf(strBannerMatch) > -1 ? PollStatus.available(responseTime) : PollStatus.unavailable(script + "banner not contained in output banner='" + strBannerMatch + "' output='" + scriptoutput + "'"));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                String reason = script + " ArrayIndexOutOfBoundsException";
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (IOException e) {
                String reason = "IOException occurred. Check for proper operation of " + script;
                LOG.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            catch (Throwable e) {
                String reason = script + "Exception occurred";
                LOG.debug(reason, e);
                serviceStatus = PollStatus.unavailable(reason);
            }
            tracker.nextAttempt();
        }
        LOG.debug("poll: GP - serviceStatus= {} {}", (Object)serviceStatus, (Object)hostAddress);
        return serviceStatus;
    }
}

