/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.browser;

import com.google.common.collect.Sets;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.opennms.netmgt.notifd.browser.BrowserNotificationMessage;

public class BrowserNotificationDispatcher {
    private final Set<Handler> handlers = Sets.newConcurrentHashSet();
    private static final BrowserNotificationDispatcher INSTANCE = new BrowserNotificationDispatcher();

    public Handler subscribe(String user, Consumer<BrowserNotificationMessage> consumer) {
        Handler handler = new Handler(user, consumer);
        this.handlers.add(handler);
        return handler;
    }

    public void unsubscribe(Handler handler) {
        this.handlers.remove(handler);
    }

    public void notify(String user, BrowserNotificationMessage notification) {
        this.handlers.stream().filter(handler -> handler.user.equals(user)).forEach(handler -> handler.consumer.accept(notification));
    }

    public static BrowserNotificationDispatcher getInstance() {
        return INSTANCE;
    }

    public static class Handler {
        public final String user;
        public final Consumer<BrowserNotificationMessage> consumer;

        private Handler(String user, Consumer<BrowserNotificationMessage> consumer) {
            this.user = Objects.requireNonNull(user);
            this.consumer = Objects.requireNonNull(consumer);
        }
    }
}

