/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.base.Strings;
import java.util.List;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collectd.ValueMappingAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueMappingPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(ValueMappingPropertyExtender.class);
    private static final String SOURCE_ATTRIBUTE = "source-attribute";
    private static final String TARGET_TYPE = "target-type";
    private static final String DEFAULT_VALUE = "default-value";

    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        String sourceAttribute = property.getParameterValue(SOURCE_ATTRIBUTE);
        String targetType = property.getParameterValue(TARGET_TYPE, AttributeType.STRING.getName());
        AttributeType targetAttributeType = AttributeType.parse((String)targetType);
        String defaultValue = property.getParameterValue(DEFAULT_VALUE);
        if (Strings.isNullOrEmpty((String)sourceAttribute)) {
            LOG.warn("Cannot execute the value-mapping property extender because: missing parameter {}", (Object)SOURCE_ATTRIBUTE);
            return null;
        }
        if (targetAttributeType == null) {
            LOG.warn("Cannot execute the value-mapping property extender because: error parsing target-type {}", (Object)targetType);
            return null;
        }
        for (AttributeGroup group : targetResource.getGroups()) {
            for (CollectionAttribute attribute : group.getAttributes()) {
                if (!sourceAttribute.equals(attribute.getName())) continue;
                String result = property.getParameterValue(attribute.getStringValue(), defaultValue);
                if (result == null) {
                    return null;
                }
                AttributeGroupType groupType = targetResource.getGroupType(property.getGroupName());
                return new SnmpAttribute(targetResource, new ValueMappingAttributeType(targetResource.getResourceType(), property, groupType, targetAttributeType), SnmpUtils.getValueFactory().getOctetString(result.getBytes()));
            }
        }
        return null;
    }
}

