/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.netmgt.collectd.RegExPropertyExtender;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpAttributeType;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.config.DataCollectionConfigFactory;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpPropertyExtenderProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPropertyExtenderProcessor.class);
    private DataCollectionConfigDao m_dataCollectionConfigDao;

    private DataCollectionConfigDao getDataCollectionConfigDao() {
        if (this.m_dataCollectionConfigDao == null) {
            this.setDataCollectionConfigDao(DataCollectionConfigFactory.getInstance());
        }
        return this.m_dataCollectionConfigDao;
    }

    public void setDataCollectionConfigDao(DataCollectionConfigDao config) {
        this.m_dataCollectionConfigDao = config;
    }

    public void process(SnmpCollectionSet collectionSet, String collectionName, String sysObjectId, String ipAddress) {
        List mibObjProperties = this.getDataCollectionConfigDao().getMibObjProperties(collectionName, sysObjectId, ipAddress);
        if (mibObjProperties.isEmpty()) {
            LOG.debug("process: there are no custom MibObj properties defined for sysObjectID {} in collection {}", (Object)collectionName, (Object)sysObjectId);
        } else {
            LOG.debug("process: analyzing properties for sysObjectID {} in collection {}: {}", new Object[]{sysObjectId, collectionName, mibObjProperties});
            List stringAttributes = collectionSet.getResources().stream().flatMap(r -> ((SnmpCollectionResource)r).getStringAttributes().stream()).collect(Collectors.toList());
            collectionSet.getResources().forEach(r -> mibObjProperties.forEach(p -> {
                String resourceName = r.getResourceTypeName();
                if (resourceName.equals("if")) {
                    resourceName = "ifIndex";
                }
                if (p.getInstance().equals(resourceName)) {
                    this.updateCollectionResource(stringAttributes, (SnmpCollectionResource)r, (MibObjProperty)p);
                }
            }));
        }
    }

    private void updateCollectionResource(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        try {
            Class<?> clazz;
            SnmpPropertyExtender extender;
            SnmpAttribute targetAttribute;
            String className = property.getClassName();
            if (className == null) {
                className = RegExPropertyExtender.class.getName();
            }
            if ((targetAttribute = (extender = (SnmpPropertyExtender)(clazz = Class.forName(className)).newInstance()).getTargetAttribute(sourceAttributes, targetResource, property)) != null) {
                LOG.debug("updateCollectionResource: adding property {} to resource {} with value {}", new Object[]{targetAttribute.getName(), targetResource, targetAttribute.getStringValue()});
                targetResource.setAttributeValue((SnmpAttributeType)targetAttribute.getAttributeType(), targetAttribute.getValue());
            } else {
                LOG.debug("updateCollectionResource: no match for resource {} (instance={}, class-name={})", new Object[]{targetResource, property.getInstance(), clazz.getSimpleName()});
            }
        }
        catch (Exception e) {
            LOG.error("Cannot update collection resource {}", (Object)targetResource, (Object)e);
        }
    }
}

