/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opennms.netmgt.collectd.HexStringAttributeType;
import org.opennms.netmgt.collectd.NumericAttributeType;
import org.opennms.netmgt.collectd.ResourceType;
import org.opennms.netmgt.collectd.SNMPCollectorEntry;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpCollectionSet;
import org.opennms.netmgt.collectd.StringAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionAttributeType;
import org.opennms.netmgt.collection.api.Persister;
import org.opennms.netmgt.collection.support.AbstractCollectionAttributeType;
import org.opennms.netmgt.config.datacollection.MibObject;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.CollectionTracker;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SnmpAttributeType
extends AbstractCollectionAttributeType {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpAttributeType.class);
    protected final MibObject m_mibObj;
    private final String m_collectionName;
    private final ResourceType m_resourceType;

    protected SnmpAttributeType(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        super(groupType);
        this.m_resourceType = resourceType;
        this.m_collectionName = collectionName;
        this.m_mibObj = mibObj;
    }

    protected String getCollectionName() {
        return this.m_collectionName;
    }

    public static List<Collectable> getCollectionTrackers(Collection<SnmpAttributeType> objList) {
        ArrayList<Collectable> trackers = new ArrayList<Collectable>(objList.size());
        for (SnmpAttributeType attrType : objList) {
            trackers.add((Collectable)attrType.getCollectionTracker());
        }
        return trackers;
    }

    private CollectionTracker getCollectionTracker() {
        SnmpInstId[] instances = this.m_resourceType.getCollectionInstances();
        if (instances != null && Boolean.getBoolean("org.opennms.netmgt.collectd.SnmpCollector.limitCollectionToInstances")) {
            return this.m_mibObj.getCollectionTracker(instances);
        }
        return this.m_mibObj.getCollectionTracker();
    }

    public static SnmpAttributeType create(ResourceType resourceType, String collectionName, MibObject mibObj, AttributeGroupType groupType) {
        if (NumericAttributeType.supportsType(mibObj.getType())) {
            return new NumericAttributeType(resourceType, collectionName, mibObj, groupType);
        }
        if (StringAttributeType.supportsType(mibObj.getType())) {
            return new StringAttributeType(resourceType, collectionName, mibObj, groupType);
        }
        if (HexStringAttributeType.supportsType(mibObj.getType())) {
            return new HexStringAttributeType(resourceType, collectionName, mibObj, groupType);
        }
        throw new IllegalArgumentException("No support exists for AttributeType '" + mibObj.getType() + "' for MIB object: " + String.valueOf(mibObj));
    }

    public ResourceType getResourceType() {
        return this.m_resourceType;
    }

    public String getGroupName() {
        return this.getGroupType().getName();
    }

    public String getAlias() {
        return this.m_mibObj.getAlias();
    }

    public String getOid() {
        return this.m_mibObj.getOid();
    }

    public String getInstance() {
        return this.m_mibObj.getInstance();
    }

    SnmpObjId getSnmpObjId() {
        return this.m_mibObj.getSnmpObjId();
    }

    public String getName() {
        return this.getAlias();
    }

    public abstract void storeAttribute(CollectionAttribute var1, Persister var2);

    public void storeResult(SnmpCollectionSet collectionSet, SNMPCollectorEntry entry, SnmpResult res) {
        LOG.debug("Setting attribute: {}.[{}] = '{}'", new Object[]{this, res.getInstance(), res.getValue()});
        SnmpCollectionResource resource = null;
        resource = this.getAlias().equals("ifAlias") ? this.m_resourceType.findAliasedResource(res.getInstance(), res.getValue().toString()) : this.m_resourceType.findResource(res.getInstance());
        if (resource == null) {
            collectionSet.notifyIfNotFound((CollectionAttributeType)this, res);
        } else {
            resource.setAttributeValue(this, res.getValue());
        }
    }

    public String toString() {
        return this.getAlias() + " [" + this.getOid() + "]";
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnmpAttributeType) {
            SnmpAttributeType attrType = (SnmpAttributeType)((Object)obj);
            return attrType.m_resourceType.equals(this.m_resourceType) && attrType.getAlias().equals(this.getAlias());
        }
        return false;
    }

    public int hashCode() {
        return this.getAlias().hashCode();
    }

    public String getGroupIfType() {
        return this.getGroupType().getIfType();
    }

    public boolean matches(SnmpObjId base, SnmpInstId inst) {
        if (!base.equals((Object)this.getSnmpObjId())) {
            return false;
        }
        if (this.getInstance().equals("ifIndex") || this.m_mibObj.getResourceType() != null) {
            return true;
        }
        return this.getInstance().equals(inst.toString());
    }
}

