/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.opennms.netmgt.collectd.SnmpCollectionAgentService;
import org.opennms.netmgt.collectd.SnmpIfData;
import org.opennms.netmgt.collection.core.DefaultCollectionAgentService;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionProxyFactoryBean;

public class DefaultSnmpCollectionAgentService
extends DefaultCollectionAgentService
implements SnmpCollectionAgentService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCollectionAgentService.class);

    public static SnmpCollectionAgentService create(Integer ifaceId, IpInterfaceDao ifaceDao, PlatformTransactionManager transMgr) {
        DefaultSnmpCollectionAgentService agent = new DefaultSnmpCollectionAgentService(ifaceId, ifaceDao);
        TransactionProxyFactoryBean bean = new TransactionProxyFactoryBean();
        bean.setTransactionManager(transMgr);
        bean.setTarget((Object)agent);
        Properties props = new Properties();
        props.put("*", "PROPAGATION_REQUIRED");
        bean.setTransactionAttributes(props);
        bean.afterPropertiesSet();
        return (SnmpCollectionAgentService)bean.getObject();
    }

    protected DefaultSnmpCollectionAgentService(Integer ifaceId, IpInterfaceDao ifaceDao) {
        super(ifaceId, ifaceDao);
    }

    private OnmsNode getNode() {
        return this.getIpInterface().getNode();
    }

    @Override
    public int getIfIndex() {
        return this.getIpInterface().getIfIndex() == null ? -1 : this.getIpInterface().getIfIndex();
    }

    @Override
    public String getSysObjectId() {
        return this.getIpInterface().getNode().getSysObjectId();
    }

    @Override
    public PrimaryType getIsSnmpPrimary() {
        return this.getIpInterface().getIsSnmpPrimary();
    }

    public String toString() {
        return "Agent[nodeid = " + this.getNodeId() + " ipaddr= " + this.getHostAddress() + "]";
    }

    @Override
    public SnmpAgentConfig getAgentConfig() {
        return SnmpPeerFactory.getInstance().getAgentConfig(this.getInetAddress(), this.getLocationName());
    }

    @Override
    public Set<SnmpIfData> getSnmpInterfaceData() {
        Set<OnmsSnmpInterface> snmpIfs = this.getSnmpInterfaces();
        LinkedHashSet<SnmpIfData> ifData = new LinkedHashSet<SnmpIfData>(snmpIfs.size());
        for (OnmsSnmpInterface snmpIface : snmpIfs) {
            DefaultSnmpCollectionAgentService.logInitializeSnmpIf(snmpIface);
            SnmpIfData snmpIfData = new SnmpIfData(snmpIface);
            ifData.add(snmpIfData);
        }
        return ifData;
    }

    private Set<OnmsSnmpInterface> getSnmpInterfaces() {
        OnmsNode node = this.getNode();
        Set snmpIfs = node.getSnmpInterfaces();
        if (snmpIfs.size() == 0) {
            LOG.debug("no known SNMP interfaces for node {}", (Object)node);
        }
        return snmpIfs;
    }

    private static void logInitializeSnmpIf(OnmsSnmpInterface snmpIface) {
        LOG.debug("initialize: snmpifindex = {}, snmpifname = {}, snmpifdescr = {}, snmpphysaddr = -{}-", new Object[]{snmpIface.getIfIndex(), snmpIface.getIfName(), snmpIface.getIfDescr(), snmpIface.getPhysAddr()});
        LOG.debug("initialize: ifLabel = '{}'", (Object)snmpIface.computeLabelForRRD());
    }
}

