/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.actiond;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.LinkedBlockingQueue;
import org.opennms.netmgt.actiond.BroadcastEventProcessor;
import org.opennms.netmgt.actiond.Executor;
import org.opennms.netmgt.config.ActiondConfigFactory;
import org.opennms.netmgt.daemon.AbstractServiceDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Actiond
extends AbstractServiceDaemon {
    private static final Logger LOG = LoggerFactory.getLogger(Actiond.class);
    private static final Actiond m_singleton = new Actiond();
    private Executor m_executor = null;
    private BroadcastEventProcessor m_eventReader = null;
    private ActiondConfigFactory m_actiondConfig;

    private Actiond() {
        super("actiond");
    }

    protected void onInit() {
        LinkedBlockingQueue<String> execQ = new LinkedBlockingQueue<String>();
        try {
            this.m_eventReader = new BroadcastEventProcessor(execQ);
        }
        catch (Throwable ex) {
            LOG.error("Failed to setup event reader", ex);
            throw new UndeclaredThrowableException(ex);
        }
        this.m_executor = new Executor(execQ, this.m_actiondConfig.getMaxProcessTime(), this.m_actiondConfig.getMaxOutstandingActions());
    }

    protected void onStart() {
        if (this.m_executor == null) {
            this.init();
        }
        this.m_executor.start();
    }

    protected void onStop() {
        try {
            if (this.m_executor != null) {
                this.m_executor.stop();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.m_eventReader != null) {
            this.m_eventReader.close();
        }
        this.m_eventReader = null;
        this.m_executor = null;
        this.m_actiondConfig = null;
    }

    protected void onPause() {
        this.m_executor.pause();
    }

    protected void onResume() {
        this.m_executor.resume();
    }

    public static Actiond getInstance() {
        return m_singleton;
    }

    public BroadcastEventProcessor getEventReader() {
        return this.m_eventReader;
    }

    public void setEventReader(BroadcastEventProcessor eventReader) {
        this.m_eventReader = eventReader;
    }

    public Executor getExecutor() {
        return this.m_executor;
    }

    public void setExecutor(Executor executor) {
        this.m_executor = executor;
    }

    public ActiondConfigFactory getActiondConfig() {
        return this.m_actiondConfig;
    }

    public void setActiondConfig(ActiondConfigFactory actiondConfig) {
        this.m_actiondConfig = actiondConfig;
    }
}

